/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.email.rest;

import edu.iu.uits.lms.email.model.EmailDetails;
import edu.iu.uits.lms.email.service.EmailService;
import edu.iu.uits.lms.email.service.LmsEmailTooBigException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Profile(value={"emailrest"})
@RestController
@RequestMapping(value={"/rest/email"})
@Tag(name="EmailRestController", description="Email sending operations")
public class EmailRestController {
    private static final Logger log = LoggerFactory.getLogger(EmailRestController.class);
    @Autowired
    private EmailService emailService;

    @PostMapping(value={"/send"})
    @PreAuthorize(value="hasAuthority('SCOPE_email:send')")
    @Operation(summary="Send an email")
    public void sendEmail(@RequestBody EmailDetails emailDetails, @RequestParam(name="emailToUseInPreProd", required=false, defaultValue="") String emailToUseInPreProd) throws LmsEmailTooBigException, MessagingException {
        this.emailService.sendEmail(emailDetails, emailToUseInPreProd);
    }
}

