/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.email.service;

import edu.iu.uits.lms.email.config.EmailServiceConfig;
import edu.iu.uits.lms.email.model.EmailDetails;
import edu.iu.uits.lms.email.model.EmailServiceAttachment;
import edu.iu.uits.lms.email.model.Priority;
import edu.iu.uits.lms.email.service.LmsEmailTooBigException;
import java.util.List;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class EmailService {
    private static final Logger log = LoggerFactory.getLogger(EmailService.class);
    private static final int SUBJECT_MAX_LENGTH = 500;
    private static final int BODY_MAX_LENGTH = 0x500000;
    @Autowired
    private JavaMailSender javaMailSender;
    @Autowired
    private EmailServiceConfig emailServiceConfig;

    public String getStandardHeader() {
        return "[LMS " + this.emailServiceConfig.getEnv().toUpperCase() + " Notifications]";
    }

    public void sendEmail(EmailDetails emailDetails) throws LmsEmailTooBigException, MessagingException {
        this.sendEmail(emailDetails, null);
    }

    public void sendEmail(EmailDetails emailDetails, String emailToUseInPreProd) throws LmsEmailTooBigException, MessagingException {
        String subject = emailDetails.getSubject();
        Object body = emailDetails.getBody();
        Object[] recipients = emailDetails.getRecipients();
        List<EmailServiceAttachment> emailServiceAttachmentList = emailDetails.getEmailServiceAttachmentList();
        boolean enableHtml = emailDetails.isEnableHtml();
        Priority priority = emailDetails.getPriority();
        String from = emailDetails.getFrom();
        if (from == null) {
            from = this.emailServiceConfig.getDefaultFrom();
        }
        if (priority == null) {
            priority = Priority.NORMAL;
        }
        if (!this.emailServiceConfig.isEnabled()) {
            log.info("mail.enabled is false. Logging message\nrecipients: " + StringUtils.arrayToCommaDelimitedString((Object[])recipients) + "\nSubject: " + subject + "\nBody:\n" + (String)body + "\n");
            return;
        }
        if (subject != null && subject.length() > 500) {
            subject = subject.substring(0, 500);
        }
        if (body != null && ((String)body).length() > 0x500000) {
            body = ((String)body).substring(0, 0x500000);
            body = (String)body + "\nThe message body exceeded 5242880 characters and this message was truncated!";
        }
        log.warn("Sending unsigned email");
        if (!"prd".equals(this.emailServiceConfig.getEnv())) {
            String htmlNewLineString = enableHtml ? "<br />" : "";
            String preBody = "** In production, this message will go to " + htmlNewLineString + "\r\n";
            for (Object recipient : recipients) {
                preBody = preBody + String.format(" - TO: %s " + htmlNewLineString + "\r\n", recipient);
            }
            body = preBody + "\r\n" + (String)body;
            recipients = new String[]{emailToUseInPreProd != null && emailToUseInPreProd.trim().length() > 0 ? emailToUseInPreProd : this.emailServiceConfig.getDefaultUnsignedTo()};
        }
        MimeMessage message = this.javaMailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        for (Object email : recipients) {
            helper.addTo((String)email);
        }
        helper.setFrom(from);
        helper.setText((String)body, enableHtml);
        helper.setSubject(subject);
        helper.setPriority(priority.getPriority());
        if (emailServiceAttachmentList != null) {
            for (EmailServiceAttachment emailServiceAttachment : emailServiceAttachmentList) {
                if (emailServiceAttachment.getFilename() == null || emailServiceAttachment.getUrl() == null) continue;
                URLDataSource attachmentDataSource = new URLDataSource(emailServiceAttachment.getUrl());
                helper.addAttachment(emailServiceAttachment.getFilename(), (DataSource)attachmentDataSource);
            }
        }
        if (message.getSize() > 0x500000) {
            throw new LmsEmailTooBigException();
        }
        this.javaMailSender.send(message);
    }
}

