package edu.uci.qa.browserdriver.drivers;

import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

import edu.uci.qa.browserdriver.BrowserDriver;
import io.github.bonigarcia.wdm.ChromeDriverManager;

/**
 * The Chrome Browser Driver. Downloads the latest chromedriver
 * and sets the default Chrome browser capabilities.
 */
public class ChromeBrowserDriver extends BrowserDriver implements WebDriver {
    private final WebDriver driver;

    public ChromeBrowserDriver() {
        ChromeDriverManager.getInstance().setup();
        this.driver = new ChromeDriver(browserCapabilities());
    }

    private Capabilities browserCapabilities() {
        DesiredCapabilities capabilities = DesiredCapabilities.chrome();
        return capabilities;
    }

    @Override
    public WebDriver webDriver() {
        return this.driver;
    }
}
