package edu.uci.qa.browserdriver.drivers;

import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

import edu.uci.qa.browserdriver.BrowserDriver;

/**
 * The HTMLBrowserDriver. Creates a headless browser with default
 * headless capabilities and JavaScript disabled.
 */
public class HtmlBrowserDriver extends BrowserDriver implements WebDriver {
    private final WebDriver driver;
    
    public HtmlBrowserDriver() {
        driver = new HtmlUnitDriver(browserCapabilities());
        ((HtmlUnitDriver)driver).setJavascriptEnabled(false);
    }
    
    @Override
    public Capabilities getCapabilities() {
        return ((HtmlUnitDriver)driver).getCapabilities();
    }
    
    public void enableJavascript(boolean value) {
        ((HtmlUnitDriver)driver).setJavascriptEnabled(value);
    }
    
    private Capabilities browserCapabilities() {
        DesiredCapabilities capabilities = DesiredCapabilities.htmlUnit();
        return capabilities;
    }
    
    @Override
    public WebDriver webDriver() {
        return this.driver;
    }
    
}
