package edu.uci.qa.browserdriver.drivers;

import java.net.MalformedURLException;
import java.net.URL;

import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;

import com.saucelabs.common.SauceOnDemandAuthentication;

import edu.uci.qa.browserdriver.BrowserDriver;

/**
 * Creates a new RemoteBrowserDriver in SauceLabs given
 * the specified Capabilities and SauceLabs' OnDemandAuthentication.
 * OnDemandAuthentication checks for the username and access key by
 * Environment Variables then a .sauce-ondemand properties file.
 * 
 * @param capabilities the capabilities to run the specified browser in SauceLAbs.
 * For more capabilities see {@linkplain https://wiki.saucelabs.com/display/DOCS/Platform+Configurator#/}
 * @throws MalformedURLException
 */
public class SauceBrowserDriver extends BrowserDriver {
    private final WebDriver driver;

    /**
     * Creates a new RemoteBrowserDriver in SauceLabs given
     * the specified Capabilities and SauceLabs' OnDemandAuthentication.
     * OnDemandAuthentication checks for the username and access key by
     * Environment Variables then a .sauce-ondemand properties file.
     * 
     * @param capabilities the capabilities to run the specified browser in SauceLAbs.
     * For more capabilities see {@linkplain https://wiki.saucelabs.com/display/DOCS/Platform+Configurator#/}
     * @throws MalformedURLException
     */
    public SauceBrowserDriver(Capabilities capabilities) throws MalformedURLException {
        SauceOnDemandAuthentication auth = new SauceOnDemandAuthentication();
        this.driver = new RemoteWebDriver(new URL(
                "http://" + auth.getUsername() + ":" + auth.getAccessKey() + "@ondemand.saucelabs.com:80/wd/hub"),
                capabilities);
    }

    @Override
    public WebDriver webDriver() {
        return this.driver;
    }

}
