package edu.uci.qa.browserdriver.drivers;

import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

import edu.uci.qa.browserdriver.BrowserDriver;
import io.github.bonigarcia.wdm.EdgeDriverManager;

public class EdgeBrowserDriver extends BrowserDriver implements WebDriver {
    private final WebDriver driver;
    
    public EdgeBrowserDriver() {
        String driver = System.getenv("EDGE_DRIVER");
        if (driver != null) System.setProperty("webdriver.edge.driver", driver);
        else EdgeDriverManager.getInstance().setup();
        
        this.driver = new EdgeDriver(browserCapabilities());
    }
    
    private Capabilities browserCapabilities() {
        DesiredCapabilities cap = DesiredCapabilities.edge();
        return cap;
    }

    @Override
    public WebDriver webDriver() {
        return this.driver;
    }
}
