package edu.uci.qa.browserdriver.drivers;

import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

import edu.uci.qa.browserdriver.BrowserDriver;
import io.github.bonigarcia.wdm.MarionetteDriverManager;

/**
 * Creates a new FireFox Browser Instance given default FireFox
 * browser capabilities. 
 */
public class FirefoxBrowserDriver extends BrowserDriver implements WebDriver {
    private final WebDriver driver;

    public FirefoxBrowserDriver() {
        String driver = System.getenv("GECKO_DRIVER");
        if (driver != null) System.setProperty("webdriver.gecko.driver", driver);
        else MarionetteDriverManager.getInstance().setup();
        
        this.driver = new FirefoxDriver(browserCapabilities());
    }

    private Capabilities browserCapabilities() {
        DesiredCapabilities cap = DesiredCapabilities.firefox();
        cap.setCapability("marionette", true);
        return cap;
    }

    @Override
    public WebDriver webDriver() {
        return this.driver;
    }
}
