package edu.uci.qa.browserdriver.drivers;

import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

import edu.uci.qa.browserdriver.BrowserDriver;
import io.github.bonigarcia.wdm.InternetExplorerDriverManager;

public class InternetExplorerBrowserDriver extends BrowserDriver implements WebDriver {
    private final WebDriver driver;

    public InternetExplorerBrowserDriver() {
        String driver = System.getenv("IE_DRIVER");
        if (driver != null) System.setProperty("webdriver.ie.driver", driver);
        else InternetExplorerDriverManager.getInstance().setup();
        
        this.driver = new InternetExplorerDriver(browserCapabilities());
    }
    
    private Capabilities browserCapabilities() {
        DesiredCapabilities cap = DesiredCapabilities.internetExplorer();
        return cap;
    }
    
    @Override
    public WebDriver webDriver() {
        return this.driver;
    }
}
