package edu.uci.qa.browserdriver.drivers;

import java.io.File;

import org.apache.commons.lang3.SystemUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.opera.OperaDriver;
import org.openqa.selenium.opera.OperaOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

import edu.uci.qa.browserdriver.BrowserDriver;
import io.github.bonigarcia.wdm.OperaDriverManager;

public class OperaBrowserDriver extends BrowserDriver implements WebDriver {
    private final WebDriver driver;
    
    public OperaBrowserDriver() {
        String driver = System.getenv("OPERA_DRIVER");
        if (driver != null) System.setProperty("webdriver.opera.driver", driver);
        else OperaDriverManager.getInstance().setup();
        
        this.driver = new OperaDriver(browserCapabilities());
    }
    
    private Capabilities browserCapabilities() {
        DesiredCapabilities cap = DesiredCapabilities.operaBlink();
        if (SystemUtils.IS_OS_LINUX) {
            OperaOptions options = new OperaOptions();
            options.setBinary(new File("/usr/bin/opera"));
            cap.setCapability(OperaOptions.CAPABILITY, options);
        }
        cap.setCapability("marionette", true);
        return cap;
    }
    
    @Override
    public WebDriver webDriver() {
        return this.driver;
    }
}
