package edu.uci.qa.browserdriver.drivers;

import java.util.ArrayList;

import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriverService;
import org.openqa.selenium.remote.DesiredCapabilities;

import edu.uci.qa.browserdriver.BrowserDriver;
import io.github.bonigarcia.wdm.PhantomJsDriverManager;

public class PhantomBrowserDriver extends BrowserDriver implements WebDriver {
    private final WebDriver driver;
    
    public PhantomBrowserDriver() {
        String driver = System.getenv("PHANTOM_DRIVER");
        if (driver != null) System.setProperty("phantomjs.binary.path", driver);
        else PhantomJsDriverManager.getInstance().setup();
        
        this.driver = new PhantomJSDriver(browserCapabilities());
    }
    
    private Capabilities browserCapabilities() {
        ArrayList<String> cliArgsCap = new ArrayList<String>();
        DesiredCapabilities caps = DesiredCapabilities.phantomjs();
        cliArgsCap.add("--web-security=false");
        cliArgsCap.add("--ssl-protocol=any");
        caps.setCapability("takesScreenshot", true);
        caps.setCapability(PhantomJSDriverService.PHANTOMJS_CLI_ARGS, cliArgsCap);
        caps.setCapability(PhantomJSDriverService.PHANTOMJS_GHOSTDRIVER_CLI_ARGS,
                new String[] { "--logLevel=2" });
        return caps;
    }

    @Override
    public WebDriver webDriver() {
        return this.driver;
    }

}
