package edu.uci.qa.browserdriver.utils;

import java.util.Arrays;
import java.util.List;

public enum BrowserType {
    FIREFOX("firefox", "ff", "marionette"),
    CHROME("chrome", "c"),
    IE("ie", "internet explorer"),
    EDGE("edge", "microsoft edge"),
    OPERA("opera", "opera blink"),
    HEADLESS("headless", "htmlunitdriver"),
    PHANTOM("phantomjs", "js"),
    NONE();

    private List<String> names;
    private BrowserType(String...names) {
        this.names = Arrays.asList(names);
    }
    
    public static BrowserType get(String name) {
        if (name == null || name.isEmpty()) return BrowserType.NONE;
        for (BrowserType b : BrowserType.values())
            if (b.names.contains(name.toLowerCase()))
                return b;
        return BrowserType.NONE;
    }
}
