package edu.uci.qa.browserdriver.utils;

import java.util.List;
import java.util.Set;

import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebDriverWrapper implements WebDriver {
    protected Logger logger() { return LoggerFactory.getLogger(getClass()); }   
    public abstract WebDriver webDriver();
    
    public void get(String url) {
        logger().info("Navigating current window to: " + url);
        webDriver().get(url);
    }

    public String getCurrentUrl() {
        return webDriver().getCurrentUrl();
    }

    public String getTitle() {
        return webDriver().getTitle();
    }

    public List<WebElement> findElements(By by) {
        logger().info("Finding elements with " + by.toString());
        return webDriver().findElements(by);
    }

    public WebElement findElement(By by) {
        logger().info("Finding element with " + by.toString());
        return webDriver().findElement(by);
    }

    public String getPageSource() {
        return webDriver().getPageSource();
    }

    public void close() {
        logger().info("Attempting to close window with handle: " + getWindowHandle());
        webDriver().close();
    }

    public void quit() {
        logger().info("Attempting to quit the driver and close all associated windows");
        webDriver().quit();
    }

    public Set<String> getWindowHandles() {
        return webDriver().getWindowHandles();
    }

    public String getWindowHandle() {
        return webDriver().getWindowHandle();
    }


    public TargetLocator switchTo() {
        return webDriver().switchTo();
    }

    public Navigation navigate() {
        return webDriver().navigate();
    }

    public Options manage() {
        return webDriver().manage();
    }
}
