/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.qa.browserdriver;

import com.assertthat.selenium_shutterbug.utils.web.ScrollStrategy;
import com.google.common.base.Function;
import edu.uci.qa.browserdriver.BrowserConfig;
import edu.uci.qa.browserdriver.BrowserDriverException;
import edu.uci.qa.browserdriver.drivers.RemoteBrowserDriver;
import edu.uci.qa.browserdriver.manager.BrowserDriverManager;
import edu.uci.qa.browserdriver.manager.BrowserManager;
import edu.uci.qa.browserdriver.manager.ElementManager;
import edu.uci.qa.browserdriver.manager.EncryptionManager;
import edu.uci.qa.browserdriver.manager.Manager;
import edu.uci.qa.browserdriver.manager.ReportManager;
import edu.uci.qa.browserdriver.manager.ScreenshotManager;
import edu.uci.qa.browserdriver.manager.WebDriverManager;
import edu.uci.qa.browserdriver.manager.defaults.DefaultManager;
import edu.uci.qa.browserdriver.reports.Report;
import edu.uci.qa.browserdriver.reports.ReportsTest;
import edu.uci.qa.browserdriver.screenshot.ElementShot;
import edu.uci.qa.browserdriver.screenshot.Screenshot;
import edu.uci.qa.browserdriver.utils.Browser;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BrowserDriver
implements BrowserDriverManager {
    private final WebDriver driver;
    private final Browser browser;
    private final Map<Class<? extends Manager>, Manager> managers;

    protected abstract WebDriver newInstance(Capabilities var1);

    protected abstract boolean setupDriver();

    protected BrowserDriver(Browser browser, Capabilities capabilities) {
        if (!this.setupDriver()) {
            throw new BrowserDriverException("Setup failed on BrowserDriver " + this.getClass().getSimpleName());
        }
        this.browser = browser;
        this.driver = this.newInstance(capabilities == null ? browser.desiredCapabilities() : capabilities);
        DefaultManager defaultManager = new DefaultManager(this, this.driver);
        this.managers = new HashMap<Class<? extends Manager>, Manager>();
        this.managers.put(ScreenshotManager.class, defaultManager);
        this.managers.put(ElementManager.class, defaultManager);
        this.managers.put(ReportManager.class, defaultManager);
        this.managers.put(WebDriverManager.class, defaultManager);
        this.managers.put(BrowserManager.class, defaultManager);
        this.managers.put(EncryptionManager.class, defaultManager);
    }

    public static BrowserDriver createBrowser() {
        return BrowserDriver.createBrowser(BrowserConfig.getInstance().getBrowser());
    }

    public static BrowserDriver createBrowser(String browser) {
        Logger logger = LoggerFactory.getLogger(BrowserDriver.class);
        Browser type = Browser.fromString(browser);
        if (type == Browser.None) {
            logger.warn("Browser with alias '" + browser + "' does not exist, switching to default browser!");
            type = BrowserConfig.getInstance().getBrowser();
        }
        return BrowserDriver.createBrowser(type);
    }

    public static BrowserDriver createBrowser(Browser browser) {
        return BrowserDriver.createBrowser(browser, (Capabilities)null);
    }

    public static BrowserDriver createBrowser(Capabilities capabilities) {
        if (capabilities.is("_sauce")) {
            return BrowserDriver.createBrowser(Browser.Sauce, capabilities);
        }
        return BrowserDriver.createBrowser(BrowserConfig.getInstance().getBrowser(), capabilities);
    }

    public static BrowserDriver createBrowser(String browser, Capabilities capabilities) {
        Logger logger = LoggerFactory.getLogger(BrowserDriver.class);
        Browser type = Browser.fromString(browser);
        if (type == Browser.None) {
            logger.warn("Browser with alias '" + browser + "' does not exist, switching to default browser!");
            type = BrowserConfig.getInstance().getBrowser();
        }
        return BrowserDriver.createBrowser(type, capabilities);
    }

    public static BrowserDriver createBrowser(Browser browser, Capabilities capabilities) {
        BrowserDriver output = null;
        BrowserDriver.preInstantiation(browser);
        try {
            Constructor<? extends BrowserDriver> c = browser.getDriver().getDeclaredConstructor(Browser.class, Capabilities.class);
            c.setAccessible(true);
            output = c.newInstance(browser, capabilities);
        }
        catch (Exception e) {
            Throwable t = e;
            if (e instanceof InvocationTargetException) {
                t = e.getCause();
            }
            throw new BrowserDriverException("Failed to create browser. Browser '" + browser + "' is either null or an unknown error occured during construction", t);
        }
        output.logger().info("Successfully instantiated " + browser + " browser!");
        output.logger().info("Running BrowserDriver post-instantiation...");
        output.postInstantiation();
        return output;
    }

    public static BrowserDriver createBrowser(URL url) {
        return BrowserDriver.createBrowser(BrowserConfig.getInstance().getBrowser(), url);
    }

    public static BrowserDriver createBrowser(String browser, URL url) {
        Logger logger = LoggerFactory.getLogger(BrowserDriver.class);
        Browser type = Browser.fromString(browser);
        if (type == Browser.None) {
            logger.warn("Browser with alias '" + browser + "' does not exist, switching to default browser!");
            type = BrowserConfig.getInstance().getBrowser();
        }
        return BrowserDriver.createBrowser(type, url);
    }

    public static BrowserDriver createBrowser(Browser browser, URL url) {
        RemoteBrowserDriver output = null;
        BrowserDriver.preInstantiation(browser);
        RemoteBrowserDriver.setUrl(url);
        output = new RemoteBrowserDriver(browser, browser.desiredCapabilities());
        output.logger().info("Successfully instantiated " + browser + " browser!");
        output.logger().info("Running BrowserDriver post-instantiation...");
        output.postInstantiation();
        return output;
    }

    public static RemoteBrowserDriver createBrowser(URL url, Capabilities capabilities) {
        RemoteBrowserDriver output = null;
        BrowserDriver.preInstantiation(Browser.Remote);
        RemoteBrowserDriver.setUrl(url);
        output = new RemoteBrowserDriver(Browser.Remote, capabilities);
        output.logger().info("Successfully instantiated a generic remote browser!");
        output.logger().info("Running BrowserDriver post-instantiation...");
        output.postInstantiation();
        return output;
    }

    public void setManager(Manager manager) {
        for (Class<? extends Manager> clzz : this.managers.keySet()) {
            if (!clzz.isAssignableFrom(manager.getClass())) continue;
            this.managers.put(clzz, manager);
            this.logger().info(clzz.getSimpleName() + " set to " + manager.getClass().getSimpleName());
        }
    }

    public <T extends Manager> T getManager(Class<T> clzz) {
        if (this.managers.containsKey(clzz)) {
            return (T)((Manager)clzz.cast(this.managers.get(clzz)));
        }
        throw new IllegalArgumentException(clzz.getSimpleName() + " does not implements any managersused by BrowserDriver");
    }

    @Override
    public WebDriver webDriver() {
        return this.getManager(WebDriverManager.class).webDriver();
    }

    private static void preInstantiation(Browser browser) {
        Logger logger = LoggerFactory.getLogger(BrowserDriver.class);
        logger.info("Running BrowserDriver pre-instantiation...");
    }

    @Override
    public void postInstantiation() {
        this.getManager(BrowserManager.class).postInstantiation();
    }

    @Override
    public void setReport(Report report) {
        this.getManager(ReportManager.class).setReport(report);
    }

    @Override
    public ReportsTest startTest(String testName) {
        return this.getManager(ReportManager.class).startTest(testName);
    }

    @Override
    public ReportsTest startTest(String testName, String description) {
        return this.getManager(ReportManager.class).startTest(testName, description);
    }

    @Override
    public ReportsTest getTest() {
        return this.getManager(ReportManager.class).getTest();
    }

    @Override
    public void endTest() {
        this.getManager(ReportManager.class).endTest();
    }

    @Override
    public void flush() {
        this.getManager(ReportManager.class).flush();
    }

    @Override
    public void closeReport() {
        this.getManager(ReportManager.class).closeReport();
    }

    @Override
    public Screenshot screenshot() {
        return this.getManager(ScreenshotManager.class).screenshot();
    }

    @Override
    public Screenshot screenshot(ScrollStrategy scroll) {
        return this.getManager(ScreenshotManager.class).screenshot(scroll);
    }

    @Override
    public ElementShot screenshot(By locator) {
        return this.getManager(ScreenshotManager.class).screenshot(locator);
    }

    @Override
    public ElementShot screenshot(WebElement element) {
        return this.getManager(ScreenshotManager.class).screenshot(element);
    }

    @Override
    public Screenshot screenshotViewport() {
        return this.getManager(ScreenshotManager.class).screenshotViewport();
    }

    @Override
    public void setDefaultTimeout(long timeout) {
        this.getManager(ElementManager.class).setDefaultTimeout(timeout);
    }

    @Override
    public long defaultTimeoutInSeconds() {
        return this.getManager(ElementManager.class).defaultTimeoutInSeconds();
    }

    @Override
    public <V> V waitUntil(Function<? super WebDriver, V> condition) {
        return this.getManager(ElementManager.class).waitUntil(condition);
    }

    @Override
    public <V> V waitUntil(Function<? super WebDriver, V> condition, long timeout) {
        return this.getManager(ElementManager.class).waitUntil(condition, timeout);
    }

    @Override
    public boolean isPresent(By locator) {
        return this.getManager(ElementManager.class).isPresent(locator);
    }

    @Override
    public boolean isPresent(By locator, long timeout) {
        return this.getManager(ElementManager.class).isPresent(locator, timeout);
    }

    @Override
    public Object executeScript(String script, Object ... objects) {
        return this.getManager(ElementManager.class).executeScript(script, objects);
    }

    @Override
    public WebElement click(By locator) {
        return this.getManager(ElementManager.class).click(locator);
    }

    @Override
    public WebElement click(By locator, long timeout) {
        return this.getManager(ElementManager.class).clear(locator, timeout);
    }

    @Override
    public WebElement clear(By locator) {
        return this.getManager(ElementManager.class).clear(locator);
    }

    @Override
    public WebElement clear(By locator, long timeout) {
        return this.getManager(ElementManager.class).clear(locator, timeout);
    }

    @Override
    public String getText(By locator) {
        return this.getManager(ElementManager.class).getText(locator);
    }

    @Override
    public String getText(By locator, long timeout) {
        return this.getManager(ElementManager.class).getText(locator, timeout);
    }

    @Override
    public WebElement sendKeys(By locator, String keysToSend) {
        return this.getManager(ElementManager.class).sendKeys(locator, keysToSend);
    }

    @Override
    public WebElement sendKeys(By locator, String keysToSend, long timeout) {
        return this.getManager(ElementManager.class).sendKeys(locator, keysToSend, timeout);
    }

    @Override
    public void scrollTo(By locator) {
        this.getManager(ElementManager.class).scrollTo(locator);
    }

    @Override
    public void scrollTo(WebElement element) {
        this.getManager(ElementManager.class).scrollTo(element);
    }

    public void get(String url) {
        this.getManager(WebDriverManager.class).get(url);
    }

    public String getCurrentUrl() {
        return this.getManager(WebDriverManager.class).getCurrentUrl();
    }

    public String getTitle() {
        return this.getManager(WebDriverManager.class).getTitle();
    }

    public List<WebElement> findElements(By by) {
        return this.getManager(WebDriverManager.class).findElements(by);
    }

    public WebElement findElement(By by) {
        return this.getManager(WebDriverManager.class).findElement(by);
    }

    public String getPageSource() {
        return this.getManager(WebDriverManager.class).getPageSource();
    }

    public void close() {
        this.getManager(WebDriverManager.class).close();
    }

    public void quit() {
        this.getManager(WebDriverManager.class).quit();
    }

    public Set<String> getWindowHandles() {
        return this.getManager(WebDriverManager.class).getWindowHandles();
    }

    public String getWindowHandle() {
        return this.getManager(WebDriverManager.class).getWindowHandle();
    }

    public WebDriver.TargetLocator switchTo() {
        return this.getManager(WebDriverManager.class).switchTo();
    }

    public WebDriver.Navigation navigate() {
        return this.getManager(WebDriverManager.class).navigate();
    }

    public WebDriver.Options manage() {
        return this.getManager(WebDriverManager.class).manage();
    }

    @Override
    public Logger logger() {
        return this.getManager(WebDriverManager.class).logger();
    }

    @Override
    @Deprecated
    public void sleep(long timeout) throws InterruptedException {
        this.getManager(BrowserManager.class).sleep(timeout);
    }

    @Override
    public boolean hasQuit() {
        return this.getManager(BrowserManager.class).hasQuit();
    }

    @Override
    public Actions actionBuilder() {
        return this.getManager(BrowserManager.class).actionBuilder();
    }

    @Override
    public Browser getBrowser() {
        return this.browser;
    }

    @Override
    public String getVersion() {
        return this.getManager(BrowserManager.class).getVersion();
    }

    @Override
    public String getSessionId() {
        return this.getManager(BrowserManager.class).getSessionId();
    }

    @Override
    public Capabilities getCapabilities() {
        return this.getManager(BrowserManager.class).getCapabilities();
    }

    @Override
    public String encrypt(String input) {
        return this.getManager(EncryptionManager.class).encrypt(input);
    }

    @Override
    public String decrypt(String input) {
        return this.getManager(EncryptionManager.class).decrypt(input);
    }
}

