/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.qa.browserdriver.drivers;

import edu.uci.qa.browserdriver.BrowserConfig;
import edu.uci.qa.browserdriver.BrowserDriver;
import edu.uci.qa.browserdriver.utils.Browser;
import io.github.bonigarcia.wdm.FirefoxDriverManager;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public class FirefoxBrowserDriver
extends BrowserDriver
implements WebDriver {
    protected FirefoxBrowserDriver(Browser browser, Capabilities capabilities) {
        super(browser, capabilities);
    }

    @Override
    protected WebDriver newInstance(Capabilities capabilities) {
        return new FirefoxDriver(capabilities);
    }

    @Override
    protected boolean setupDriver() {
        String driver = BrowserConfig.getInstance().getDriverLocation(this.getBrowser());
        if (driver != null) {
            System.setProperty("webdriver.gecko.driver", driver);
        } else {
            FirefoxDriverManager.getInstance().setup();
        }
        return true;
    }

    public static Capabilities desiredCapabilities() {
        DesiredCapabilities cap = DesiredCapabilities.firefox();
        cap.setCapability("marionette", true);
        return cap;
    }
}

