/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.qa.browserdriver.drivers;

import edu.uci.qa.browserdriver.BrowserConfig;
import edu.uci.qa.browserdriver.BrowserDriver;
import edu.uci.qa.browserdriver.utils.Browser;
import io.github.bonigarcia.wdm.OperaDriverManager;
import java.io.File;
import org.apache.commons.lang3.SystemUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.opera.OperaDriver;
import org.openqa.selenium.opera.OperaOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public class OperaBrowserDriver
extends BrowserDriver
implements WebDriver {
    protected OperaBrowserDriver(Browser browser, Capabilities capabilities) {
        super(browser, capabilities);
    }

    @Override
    protected WebDriver newInstance(Capabilities capabilities) {
        return new OperaDriver(capabilities);
    }

    @Override
    protected boolean setupDriver() {
        String driver = BrowserConfig.getInstance().getDriverLocation(this.getBrowser());
        if (driver != null) {
            System.setProperty("webdriver.opera.driver", driver);
        } else {
            OperaDriverManager.getInstance().setup();
        }
        return true;
    }

    public static Capabilities desiredCapabilities() {
        DesiredCapabilities cap = DesiredCapabilities.operaBlink();
        if (SystemUtils.IS_OS_LINUX) {
            OperaOptions options = new OperaOptions();
            options.setBinary(new File("/usr/bin/opera"));
            cap.setCapability("operaOptions", (Object)options);
        }
        cap.setCapability("marionette", true);
        return cap;
    }
}

