/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.qa.browserdriver.reports;

import com.assertthat.selenium_shutterbug.utils.file.FileUtil;
import com.relevantcodes.extentreports.ExtentTest;
import com.relevantcodes.extentreports.LogStatus;
import edu.uci.qa.browserdriver.screenshot.Shot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;

public class ReportsTest
extends ExtentTest {
    private static final long serialVersionUID = -6673263657217503522L;
    private final List<ReportsTest> children = new LinkedList<ReportsTest>();
    private final File report;
    private final String reportName;
    private int id = -1;

    public ReportsTest(String testName, String description, File report) {
        super(testName, description);
        this.report = report;
        String filename = report.getName();
        int pos = filename.lastIndexOf(46);
        this.reportName = pos > 0 ? filename.substring(0, pos) : filename;
    }

    public void setId(int id) {
        if (this.id == -1) {
            this.id = id;
        }
    }

    public final int getId() {
        return this.id;
    }

    public String getReportName() {
        return this.reportName;
    }

    public void logLink(LogStatus status, Shot<?> shot) {
        File imageFile;
        File parent = this.report.getParentFile();
        if (parent == null) {
            parent = new File("./");
        }
        if (!(imageFile = new File(parent.getPath(), this.reportName + "/" + shot.getLocationExtension() + "/" + shot.getFileName() + ".png")).exists()) {
            imageFile.mkdirs();
            FileUtil.writeImage((BufferedImage)shot.getImage(), (String)"PNG", (File)imageFile);
        }
        String link = parent.toURI().relativize(imageFile.toURI()).getPath();
        this.logLink(status, link, shot.getFileName());
    }

    public void logLink(LogStatus status, Shot<?> shot, String text) {
        File imageFile;
        File parent = this.report.getParentFile();
        if (parent == null) {
            parent = new File("./");
        }
        if (!(imageFile = new File(parent.getPath(), this.reportName + "/" + shot.getLocationExtension() + "/" + shot.getFileName() + ".png")).exists()) {
            imageFile.mkdirs();
            FileUtil.writeImage((BufferedImage)shot.getImage(), (String)"PNG", (File)imageFile);
        }
        this.logLink(status, parent.toURI().relativize(imageFile.toURI()).getPath(), text);
    }

    public void logLink(LogStatus status, File url) {
        File parent = this.report.getParentFile();
        if (parent == null) {
            parent = new File("./");
        }
        String link = ReportsTest.getRelativePath(url.getAbsolutePath(), this.report.getAbsolutePath(), "/");
        this.logLink(status, link, link);
    }

    public void logLink(LogStatus status, File url, String text) {
        File parent = this.report.getParentFile();
        if (parent == null) {
            parent = new File("./");
        }
        this.logLink(status, ReportsTest.getRelativePath(url.getAbsolutePath(), this.report.getAbsolutePath(), "/"), text);
    }

    public void logLink(LogStatus status, String url) {
        this.logLink(status, url, url);
    }

    public void logLink(LogStatus status, String url, String text) {
        this.log(status, this.addLink(url, text));
    }

    public String addLink(String url) {
        return this.addLink(url, url);
    }

    public String addLink(String url, String text) {
        return "<a href=\"" + url + "\" target=\"_blank\">" + text + "</a>";
    }

    public void logWithBase64(LogStatus status, BufferedImage image) {
        this.log(status, this.addBase64ScreenShot(this.asBase64(image)));
    }

    public void logWithBase64(LogStatus status, Shot<?> screenshot) {
        this.log(status, this.addBase64ScreenShot(screenshot.toBase64()));
    }

    public void log(LogStatus status, BufferedImage image) {
        System.out.println(this.reportName);
        File parent = this.report.getParentFile();
        if (parent == null) {
            parent = new File("./");
        }
        File imageFile = new File(parent.getPath(), this.reportName + "/" + new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss_SSS").format(new Date()) + ".png");
        imageFile.mkdirs();
        FileUtil.writeImage((BufferedImage)image, (String)"PNG", (File)imageFile);
        this.log(status, this.addScreenCapture(parent.toURI().relativize(imageFile.toURI()).getPath()));
    }

    public void log(LogStatus status, Shot<?> screenshot) {
        File imageFile;
        File parent = this.report.getParentFile();
        if (parent == null) {
            parent = new File("./");
        }
        if (!(imageFile = new File(parent.getPath(), this.reportName + "/" + screenshot.getLocationExtension() + "/" + screenshot.getFileName() + ".png")).exists()) {
            imageFile.mkdirs();
            FileUtil.writeImage((BufferedImage)screenshot.getImage(), (String)"PNG", (File)imageFile);
        }
        this.log(status, this.addScreenCapture(parent.toURI().relativize(imageFile.toURI()).getPath()));
    }

    public String asBase64(BufferedImage image) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", os);
            return "data:image/png;base64," + Base64.getEncoder().encodeToString(os.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ReportsTest startChild(String childName) {
        return this.startChild(childName, "");
    }

    public ReportsTest startChild(String childName, String description) {
        ReportsTest out = new ReportsTest(childName, description, this.report);
        this.children.add(out);
        out.setId(this.children.size() - 1);
        this.appendChild(out);
        return out;
    }

    public ReportsTest getChild(int id) {
        return this.children.get(id);
    }

    public int childCount() {
        return this.children.size();
    }

    private static String getRelativePath(String targetPath, String basePath, String pathSeparator) {
        int commonIndex;
        String normalizedTargetPath = FilenameUtils.normalizeNoEndSeparator((String)targetPath);
        String normalizedBasePath = FilenameUtils.normalizeNoEndSeparator((String)basePath);
        if (pathSeparator.equals("/")) {
            normalizedTargetPath = FilenameUtils.separatorsToUnix((String)normalizedTargetPath);
            normalizedBasePath = FilenameUtils.separatorsToUnix((String)normalizedBasePath);
        } else if (pathSeparator.equals("\\")) {
            normalizedTargetPath = FilenameUtils.separatorsToWindows((String)normalizedTargetPath);
            normalizedBasePath = FilenameUtils.separatorsToWindows((String)normalizedBasePath);
        } else {
            throw new IllegalArgumentException("Unrecognised dir separator '" + pathSeparator + "'");
        }
        String[] base = normalizedBasePath.split(Pattern.quote(pathSeparator));
        String[] target = normalizedTargetPath.split(Pattern.quote(pathSeparator));
        StringBuffer common = new StringBuffer();
        for (commonIndex = 0; commonIndex < target.length && commonIndex < base.length && target[commonIndex].equals(base[commonIndex]); ++commonIndex) {
            common.append(target[commonIndex] + pathSeparator);
        }
        if (commonIndex == 0) {
            throw new RuntimeException("No common path element found for '" + normalizedTargetPath + "' and '" + normalizedBasePath + "'");
        }
        boolean baseIsFile = true;
        File baseResource = new File(normalizedBasePath);
        if (baseResource.exists()) {
            baseIsFile = baseResource.isFile();
        } else if (basePath.endsWith(pathSeparator)) {
            baseIsFile = false;
        }
        StringBuffer relative = new StringBuffer();
        if (base.length != commonIndex) {
            int numDirsUp = baseIsFile ? base.length - commonIndex - 1 : base.length - commonIndex;
            for (int i = 0; i < numDirsUp; ++i) {
                relative.append(".." + pathSeparator);
            }
        }
        relative.append(normalizedTargetPath.substring(common.length()));
        return relative.toString();
    }
}

