/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.qa.browserdriver.sauce;

import edu.uci.qa.browserdriver.sauce.SauceCapabilities;
import edu.uci.qa.browserdriver.sauce.SauceDevice;
import edu.uci.qa.browserdriver.sauce.SauceLatest;
import edu.uci.qa.browserdriver.utils.Browser;
import edu.uci.qa.browserdriver.utils.Platform;
import edu.uci.qa.browserdriver.utils.Version;

public class SauceBrowser {
    Browser browser;
    Platform platform;
    Version version;

    public SauceBrowser(Browser browser, Platform platform, Version version) {
        this.browser = browser;
        this.platform = platform;
        this.version = version;
    }

    SauceCapabilities set(SauceCapabilities cap) {
        if (this.platform.family() == Platform.Mac) {
            cap.setCapability("platform", this.platform.family().toString() + " " + this.platform.version().toString());
        } else {
            cap.setCapability("platform", this.platform.toString());
        }
        cap.setCapability("version", this.version.get());
        cap.setCapability("browserName", this.browser.toString());
        cap.setCapability("browserType", this.browser);
        return cap;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SauceLatest) {
            return ((SauceLatest)obj).device == null && this.browser == ((SauceLatest)obj).browser && this.platform == ((SauceLatest)obj).platform;
        }
        if (obj instanceof SauceBrowser) {
            return this.browser == ((SauceBrowser)obj).browser && this.platform == ((SauceBrowser)obj).platform && this.version.equals(((SauceBrowser)obj).version);
        }
        if (obj instanceof SauceDevice) {
            return false;
        }
        return super.equals(obj);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.browser);
        sb.append(" ");
        sb.append((Object)this.platform);
        sb.append(" v");
        sb.append(this.version);
        return sb.toString();
    }

    public int hashCode() {
        return 1;
    }
}

