/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.qa.browserdriver.sauce;

import edu.uci.qa.browserdriver.sauce.SauceBrowser;
import edu.uci.qa.browserdriver.sauce.SauceCapabilities;
import edu.uci.qa.browserdriver.sauce.SauceLabs;
import edu.uci.qa.browserdriver.sauce.SauceLatest;
import edu.uci.qa.browserdriver.utils.Device;
import edu.uci.qa.browserdriver.utils.Version;

public class SauceDevice {
    Device device;
    SauceLabs.Orientation orientation;
    Version version;

    public SauceDevice(Device device) {
        this.device = device;
    }

    public SauceDevice(Device device, SauceLabs.Orientation orientation, Version version) {
        this.device = device;
        this.orientation = orientation;
        this.version = version;
    }

    SauceCapabilities set(SauceCapabilities cap) {
        cap.setCapability("deviceOrientation", this.orientation.toString());
        cap.setCapability("platformVersion", this.version.get());
        cap.setCapability("platformName", this.device.platformName());
        cap.setCapability("browserName", this.device.browserName());
        cap.setCapability("deviceName", this.device.deviceName());
        cap.setCapability("deviceType", this.device);
        return cap;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SauceLatest) {
            return ((SauceLatest)obj).browser == null && this.device == ((SauceLatest)obj).device;
        }
        if (obj instanceof SauceDevice) {
            return this.device == ((SauceDevice)obj).device && this.orientation == ((SauceDevice)obj).orientation && this.version.equals(((SauceDevice)obj).version);
        }
        if (obj instanceof SauceBrowser) {
            return false;
        }
        return super.equals(obj);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.device);
        sb.append(" ");
        sb.append((Object)this.orientation);
        sb.append(" v");
        sb.append(this.version);
        return sb.toString();
    }

    public int hashCode() {
        return 1;
    }
}

