/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.qa.browserdriver.sauce;

import com.saucelabs.common.SauceOnDemandAuthentication;
import com.saucelabs.saucerest.SauceREST;
import edu.uci.qa.browserdriver.BrowserDriver;
import edu.uci.qa.browserdriver.BrowserDriverException;
import edu.uci.qa.browserdriver.drivers.SauceBrowserDriver;
import edu.uci.qa.browserdriver.sauce.SauceBrowser;
import edu.uci.qa.browserdriver.sauce.SauceCapabilities;
import edu.uci.qa.browserdriver.sauce.SauceDevice;
import edu.uci.qa.browserdriver.sauce.SauceLatest;
import edu.uci.qa.browserdriver.utils.Browser;
import edu.uci.qa.browserdriver.utils.Device;
import edu.uci.qa.browserdriver.utils.Family;
import edu.uci.qa.browserdriver.utils.Platform;
import edu.uci.qa.browserdriver.utils.Usable;
import edu.uci.qa.browserdriver.utils.Version;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class SauceLabs {
    private static SauceOnDemandAuthentication authentication = new SauceOnDemandAuthentication();
    private static SauceREST api = new SauceREST(authentication.getUsername(), authentication.getAccessKey());
    public static Query query;

    private static Query getQuery() {
        if (query == null) {
            query = new Query();
        }
        return query;
    }

    public static URL createUrl() {
        SauceOnDemandAuthentication auth = new SauceOnDemandAuthentication();
        try {
            if (auth.getUsername() != null && auth.getAccessKey() != null) {
                return new URL("http://" + auth.getUsername() + ":" + auth.getAccessKey() + "@ondemand.saucelabs.com:80/wd/hub");
            }
            throw new MalformedURLException("SauceOnDemandAuthentication was null!");
        }
        catch (MalformedURLException e) {
            throw new BrowserDriverException(e.toString());
        }
    }

    public static SauceCapabilities get(Browser browser, Platform platform, String version) {
        if (browser.family() != Family.DESKTOP) {
            throw new IllegalArgumentException("Specified browser is not a Desktop browser: " + browser);
        }
        SauceBrowser sb = new SauceBrowser(browser, platform, new Version(version));
        Platform.PlatformComparator c = new Platform.PlatformComparator();
        for (SauceBrowser sbrowser : SauceLabs.getQuery().desktopBrowsers) {
            if (sbrowser.browser != browser || (!version.equalsIgnoreCase("latest") ? !sbrowser.version.equals(sb.version) : !SauceLabs.getQuery().latest.get(sbrowser).equals(sbrowser.version))) continue;
            if (platform != Platform.Any && (platform.family() != sbrowser.platform.family() || platform != Platform.Windows && platform != Platform.Mac && platform != sbrowser.platform) || c.compare(sbrowser.platform, sb.platform) < 0) continue;
            sb = sbrowser;
        }
        return sb.set(new SauceCapabilities());
    }

    public static SauceCapabilities get(Browser browser, Platform platform) {
        return SauceLabs.get(browser, platform, "latest");
    }

    public static SauceCapabilities get(Browser browser, String version) {
        return SauceLabs.get(browser, Platform.Any, version);
    }

    public static SauceCapabilities get(Browser browser) {
        return SauceLabs.get(browser, Platform.Any);
    }

    public static SauceCapabilities get(Device device, Orientation orientation, String version) {
        if (device == Device.iOS) {
            device = Device.iPhone;
        } else if (device == Device.Android || device == Device.Any) {
            device = Device.AndroidPhone;
        }
        orientation = orientation == Orientation.Any ? Orientation.Portrait : orientation;
        Version v = new Version(version);
        if (version.equalsIgnoreCase("latest")) {
            v = SauceLabs.query.latest.get(new SauceDevice(device));
        }
        return new SauceDevice(device, orientation, v).set(new SauceCapabilities());
    }

    public static SauceCapabilities get(Device device, Orientation orientation) {
        return SauceLabs.get(device, orientation, "latest");
    }

    public static SauceCapabilities get(Device device, String version) {
        return SauceLabs.get(device, Orientation.Any, version);
    }

    public static SauceCapabilities get(Device device) {
        return SauceLabs.get(device, Orientation.Any);
    }

    private static List<SauceCapabilities> getAll(Family family, Platform platform, String version) {
        ArrayList<SauceCapabilities> out = new ArrayList<SauceCapabilities>();
        if (family != Family.DESKTOP) {
            return out;
        }
        for (SauceBrowser sbrowser : SauceLabs.getQuery().desktopBrowsers) {
            if (platform != Platform.Any && sbrowser.platform.family() != platform.family() || platform != Platform.Any && platform != Platform.Windows && platform != Platform.Mac && platform != sbrowser.platform || version != null && !version.isEmpty() && (version.equalsIgnoreCase("latest") ? !SauceLabs.query.latest.get(sbrowser).equals(sbrowser.version) : !sbrowser.version.equals(new Version(version)))) continue;
            out.add(sbrowser.set(new SauceCapabilities()));
        }
        return out;
    }

    private static List<SauceCapabilities> getAll(Browser browser, Platform platform, String version) {
        ArrayList<SauceCapabilities> out = new ArrayList<SauceCapabilities>();
        for (SauceBrowser sbrowser : SauceLabs.getQuery().desktopBrowsers) {
            if (sbrowser.browser != browser || platform != Platform.Any && sbrowser.platform.family() != platform.family() || platform != Platform.Any && platform != Platform.Windows && platform != Platform.Mac && platform != sbrowser.platform || version != null && !version.isEmpty() && (version.equalsIgnoreCase("latest") ? !SauceLabs.query.latest.get(sbrowser).equals(sbrowser.version) : !sbrowser.version.equals(new Version(version)))) continue;
            out.add(sbrowser.set(new SauceCapabilities()));
        }
        return out;
    }

    private static List<SauceCapabilities> getAll(Device device, Orientation orientation, String version) {
        ArrayList<SauceCapabilities> out = new ArrayList<SauceCapabilities>();
        for (SauceDevice sdevice : SauceLabs.getQuery().deviceBrowsers) {
            if (device != Device.Any && device.family() != sdevice.device.family() || device != Device.Any && device != Device.Android && device != Device.iOS && device != sdevice.device || orientation != Orientation.Any && orientation != sdevice.orientation || version != null && !version.isEmpty() && (version.equalsIgnoreCase("latest") ? !SauceLabs.query.latest.get(sdevice).equals(sdevice.version) : !sdevice.version.equals(new Version(version)))) continue;
            out.add(sdevice.set(new SauceCapabilities()));
        }
        return out;
    }

    public static Collection<SauceCapabilities> getAll(Browser browser, String ... versions) {
        HashSet<SauceCapabilities> out = new HashSet<SauceCapabilities>();
        for (String v : versions) {
            out.addAll(SauceLabs.getAll(browser, Platform.Any, v));
        }
        return out;
    }

    public static Collection<SauceCapabilities> getAll(String version, Browser ... browsers) {
        HashSet<SauceCapabilities> out = new HashSet<SauceCapabilities>();
        for (Browser b : browsers) {
            out.addAll(SauceLabs.getAll(b, Platform.Any, version));
        }
        return out;
    }

    public static Collection<SauceCapabilities> getAll(Device device, String ... versions) {
        HashSet<SauceCapabilities> out = new HashSet<SauceCapabilities>();
        for (String v : versions) {
            out.addAll(SauceLabs.getAll(device, Orientation.Any, v));
        }
        return out;
    }

    public static Collection<SauceCapabilities> getAll(String version, Device ... devices) {
        HashSet<SauceCapabilities> out = new HashSet<SauceCapabilities>();
        for (Device d : devices) {
            out.addAll(SauceLabs.getAll(d, Orientation.Any, version));
        }
        return out;
    }

    public static Collection<SauceCapabilities> getAll(String version, Usable ... browsers) {
        HashSet<SauceCapabilities> out = new HashSet<SauceCapabilities>();
        for (Usable u : browsers) {
            if (u instanceof Browser) {
                out.addAll(SauceLabs.getAll((Browser)u, Platform.Any, version));
                continue;
            }
            if (!(u instanceof Device)) continue;
            out.addAll(SauceLabs.getAll((Device)u, Orientation.Any, version));
        }
        return out;
    }

    public static Collection<SauceCapabilities> getAll(String version, Platform ... platforms) {
        HashSet<SauceCapabilities> out = new HashSet<SauceCapabilities>();
        for (Platform p : platforms) {
            out.addAll(SauceLabs.getAll(Family.DESKTOP, p, version));
        }
        return out;
    }

    public static Collection<SauceCapabilities> getAll(Platform platform, String ... versions) {
        HashSet<SauceCapabilities> out = new HashSet<SauceCapabilities>();
        for (String v : versions) {
            out.addAll(SauceLabs.getAll(Family.DESKTOP, platform, v));
        }
        return out;
    }

    public static Collection<SauceCapabilities> getAll(Orientation orientation, String ... versions) {
        HashSet<SauceCapabilities> out = new HashSet<SauceCapabilities>();
        for (String v : versions) {
            out.addAll(SauceLabs.getAll(Device.Any, orientation, v));
        }
        return out;
    }

    public static Collection<SauceCapabilities> getAll(String version, Orientation ... orientations) {
        HashSet<SauceCapabilities> out = new HashSet<SauceCapabilities>();
        for (Orientation o : orientations) {
            out.addAll(SauceLabs.getAll(Device.Any, o, version));
        }
        return out;
    }

    public static Collection<SauceCapabilities> getAll(Device device, Orientation ... orientations) {
        HashSet<SauceCapabilities> out = new HashSet<SauceCapabilities>();
        for (Orientation o : orientations) {
            out.addAll(SauceLabs.getAll(device, o, null));
        }
        return out;
    }

    public static Collection<SauceCapabilities> getAll(Orientation orientation, Device ... devices) {
        HashSet<SauceCapabilities> out = new HashSet<SauceCapabilities>();
        for (Device d : devices) {
            out.addAll(SauceLabs.getAll(d, orientation, null));
        }
        return out;
    }

    public static Collection<SauceCapabilities> getAll(Browser browser, Platform ... platforms) {
        HashSet<SauceCapabilities> out = new HashSet<SauceCapabilities>();
        for (Platform p : platforms) {
            out.addAll(SauceLabs.getAll(browser, p, null));
        }
        return out;
    }

    public static Collection<SauceCapabilities> getAll(Platform platform, Browser ... browsers) {
        HashSet<SauceCapabilities> out = new HashSet<SauceCapabilities>();
        for (Browser b : browsers) {
            out.addAll(SauceLabs.getAll(b, platform, null));
        }
        return out;
    }

    public static Collection<SauceCapabilities> getAll(Object o) {
        HashSet<SauceCapabilities> out = new HashSet<SauceCapabilities>();
        if (o instanceof Browser) {
            out.addAll(SauceLabs.getAll((Browser)o, Platform.Any, null));
        } else if (o instanceof Device) {
            out.addAll(SauceLabs.getAll((Device)o, Orientation.Any, null));
        } else if (o instanceof Platform) {
            out.addAll(SauceLabs.getAll(Family.DESKTOP, (Platform)((Object)o), null));
        } else if (o instanceof Orientation) {
            out.addAll(SauceLabs.getAll(Device.Any, (Orientation)((Object)o), null));
        } else if (o instanceof String) {
            out.addAll(SauceLabs.getAll(Family.DESKTOP, Platform.Any, (String)o));
            out.addAll(SauceLabs.getAll(Device.Any, Orientation.Any, (String)o));
        }
        return out;
    }

    public static Collection<SauceCapabilities> getAll(String ... versions) {
        HashSet<SauceCapabilities> out = new HashSet<SauceCapabilities>();
        for (String v : versions) {
            out.addAll(SauceLabs.getAll(Family.DESKTOP, Platform.Any, v));
            out.addAll(SauceLabs.getAll(Device.Any, Orientation.Any, v));
        }
        return out;
    }

    public static Collection<SauceCapabilities> getAll(Platform ... platforms) {
        HashSet<SauceCapabilities> out = new HashSet<SauceCapabilities>();
        for (Platform p : platforms) {
            out.addAll(SauceLabs.getAll(Family.DESKTOP, p, null));
        }
        return out;
    }

    public static Collection<SauceCapabilities> getAll(Browser ... browsers) {
        HashSet<SauceCapabilities> out = new HashSet<SauceCapabilities>();
        for (Browser b : browsers) {
            out.addAll(SauceLabs.getAll(b, Platform.Any, null));
        }
        return out;
    }

    public static Collection<SauceCapabilities> getAll(Usable ... browsers) {
        HashSet<SauceCapabilities> out = new HashSet<SauceCapabilities>();
        for (Usable u : browsers) {
            if (u instanceof Browser) {
                out.addAll(SauceLabs.getAll((Browser)u, Platform.Any, null));
                continue;
            }
            if (!(u instanceof Device)) continue;
            out.addAll(SauceLabs.getAll((Device)u, Orientation.Any, null));
        }
        return out;
    }

    public static Collection<SauceCapabilities> getAll(Device ... devices) {
        HashSet<SauceCapabilities> out = new HashSet<SauceCapabilities>();
        for (Device d : devices) {
            out.addAll(SauceLabs.getAll(d, Orientation.Any, null));
        }
        return out;
    }

    public static Collection<SauceCapabilities> getAll(Orientation ... orientations) {
        HashSet<SauceCapabilities> out = new HashSet<SauceCapabilities>();
        for (Orientation o : orientations) {
            out.addAll(SauceLabs.getAll(Device.Any, o, null));
        }
        return out;
    }

    public static Collection<SauceCapabilities> getAll() {
        HashSet<SauceCapabilities> out = new HashSet<SauceCapabilities>();
        out.addAll(SauceLabs.getAll(Family.DESKTOP, Platform.Any, null));
        out.addAll(SauceLabs.getAll(Device.Any, Orientation.Any, null));
        return out;
    }

    private static Collection<SauceCapabilities> getAll(String version) {
        HashSet<SauceCapabilities> out = new HashSet<SauceCapabilities>();
        out.addAll(SauceLabs.getAll(Family.DESKTOP, Platform.Any, version));
        out.addAll(SauceLabs.getAll(Device.Any, Orientation.Any, version));
        return out;
    }

    public static Collection<SauceCapabilities> getLatest() {
        return SauceLabs.getAll("latest");
    }

    public static Collection<SauceCapabilities> getLatest(Object o) {
        if (o instanceof Browser) {
            return SauceLabs.getAll("latest", (Browser)o);
        }
        if (o instanceof Device) {
            return SauceLabs.getAll("latest", (Device)o);
        }
        if (o instanceof Platform) {
            return SauceLabs.getAll("latest", (Platform)((Object)o));
        }
        if (o instanceof Orientation) {
            return SauceLabs.getAll("latest", (Orientation)((Object)o));
        }
        if (o instanceof String) {
            return SauceLabs.getAll("latest", (String)o);
        }
        return null;
    }

    public static Collection<SauceCapabilities> getLatest(Browser ... browsers) {
        return SauceLabs.getAll("latest", browsers);
    }

    public static Collection<SauceCapabilities> getLatest(Usable ... usables) {
        return SauceLabs.getAll("latest", usables);
    }

    public static Collection<SauceCapabilities> getLatest(Device ... devices) {
        return SauceLabs.getAll("latest", devices);
    }

    public static Collection<SauceCapabilities> getLatest(Platform ... platforms) {
        return SauceLabs.getAll("latest", platforms);
    }

    public static Collection<SauceCapabilities> getLatest(Orientation ... orientations) {
        return SauceLabs.getAll("latest", orientations);
    }

    public static Collection<SauceCapabilities> getLatest(Browser browser, Platform ... platforms) {
        HashSet<SauceCapabilities> out = new HashSet<SauceCapabilities>();
        for (Platform p : platforms) {
            out.addAll(SauceLabs.getAll(browser, p, "latest"));
        }
        return out;
    }

    public static Collection<SauceCapabilities> getLatest(Platform platform, Browser ... browsers) {
        HashSet<SauceCapabilities> out = new HashSet<SauceCapabilities>();
        for (Browser b : browsers) {
            out.addAll(SauceLabs.getAll(b, platform, "latest"));
        }
        return out;
    }

    public static Collection<SauceCapabilities> getLatest(Device device, Orientation ... orientations) {
        HashSet<SauceCapabilities> out = new HashSet<SauceCapabilities>();
        for (Orientation o : orientations) {
            out.addAll(SauceLabs.getAll(device, o, "latest"));
        }
        return out;
    }

    public static Collection<SauceCapabilities> getLatest(Orientation orientation, Device ... devices) {
        HashSet<SauceCapabilities> out = new HashSet<SauceCapabilities>();
        for (Device d : devices) {
            out.addAll(SauceLabs.getAll(d, orientation, "latest"));
        }
        return out;
    }

    public static void refreshApi() {
        authentication = new SauceOnDemandAuthentication();
        api = new SauceREST(authentication.getUsername(), authentication.getAccessKey());
    }

    public static String getPublicJobLink(BrowserDriver driver) {
        if (!(driver instanceof SauceBrowserDriver)) {
            throw new IllegalArgumentException("Cannot get SauceLab's job link for driver, because driver is not a SauceBrowserDriver!");
        }
        return api.getPublicJobLink(driver.getSessionId());
    }

    public static String getPublicJobLink(String sessionId) {
        return api.getPublicJobLink(sessionId);
    }

    public static void updateJobInfo(String jobId, Map<String, Object> updates) {
        api.updateJobInfo(jobId, updates);
    }

    static class Query {
        protected List<SauceBrowser> desktopBrowsers = new ArrayList<SauceBrowser>();
        protected List<SauceDevice> deviceBrowsers = new ArrayList<SauceDevice>();
        protected Map<Object, List<Version>> ignoreVersions = new HashMap<Object, List<Version>>();
        protected Map<SauceLatest, Version> latest;

        protected Query() {
            this.addIgnores();
            this.queryWebDriver();
            this.latest = this.populateLatest();
        }

        protected void addIgnores() {
            this.ignoreVersions.put(Device.iOS, Arrays.asList(new Version("5.1"), new Version("6.1"), new Version("6.0")));
            this.ignoreVersions.put(Device.Android, Arrays.asList(new Version("4.0"), new Version("4.2"), new Version("4.1"), new Version("4.3")));
            this.ignoreVersions.put(Browser.Opera, Arrays.asList(new Version("11")));
            this.ignoreVersions.put(new SauceLatest(Browser.Chrome, Platform.Linux), Arrays.asList(new Version("45"), new Version("44"), new Version("43"), new Version("42"), new Version("41"), new Version("40"), new Version("39"), new Version("38"), new Version("37"), new Version("36"), new Version("35"), new Version("34"), new Version("33")));
        }

        protected String queryData() {
            return api.getSupportedPlatforms("webdriver");
        }

        protected void queryWebDriver() {
            String query = this.queryData();
            try {
                JSONArray browsers = new JSONArray(query);
                for (int i = 0; i < browsers.length(); ++i) {
                    SauceBrowser b;
                    Platform platform;
                    JSONObject bquery = browsers.getJSONObject(i);
                    String v = bquery.getString("short_version");
                    if (v.toLowerCase().startsWith("dev") || v.toLowerCase().startsWith("beta")) continue;
                    Version version = new Version(v);
                    if (bquery.has("device")) {
                        if (bquery.getString("device").toLowerCase().startsWith("iphone") || bquery.getString("device").toLowerCase().startsWith("ipad")) {
                            Device device = Device.fromString(bquery.getString("device"));
                            if (this.ignoreVersions.containsKey(device.family()) && this.ignoreVersions.get(device.family()).contains(version) || this.ignoreVersions.containsKey(device) && this.ignoreVersions.get(device).contains(version)) continue;
                            this.deviceBrowsers.add(new SauceDevice(device, Orientation.Portrait, version));
                            this.deviceBrowsers.add(new SauceDevice(device, Orientation.Landscape, version));
                            continue;
                        }
                        if (!bquery.getString("device").equalsIgnoreCase("android") || this.ignoreVersions.containsKey(Device.Android) && this.ignoreVersions.get(Device.Android).contains(version) || this.ignoreVersions.containsKey(Device.AndroidPhone) && this.ignoreVersions.get(Device.AndroidPhone).contains(version) || this.ignoreVersions.containsKey(Device.AndroidTablet) && this.ignoreVersions.get(Device.AndroidTablet).contains(version)) continue;
                        this.deviceBrowsers.add(new SauceDevice(Device.AndroidPhone, Orientation.Portrait, version));
                        this.deviceBrowsers.add(new SauceDevice(Device.AndroidPhone, Orientation.Landscape, version));
                        this.deviceBrowsers.add(new SauceDevice(Device.AndroidTablet, Orientation.Portrait, version));
                        this.deviceBrowsers.add(new SauceDevice(Device.AndroidTablet, Orientation.Landscape, version));
                        continue;
                    }
                    Browser browser = Browser.fromString(bquery.getString("api_name"));
                    if (this.ignoreVersions.containsKey(browser) && this.ignoreVersions.get(browser).contains(version) || this.ignoreVersions.containsKey((Object)(platform = Platform.fromString(bquery.getString("os"))).family()) && this.ignoreVersions.get((Object)platform.family()).contains(version) || this.ignoreVersions.containsKey((Object)platform) && this.ignoreVersions.get((Object)platform).contains(version) || this.ignoreVersions.containsKey(b = new SauceBrowser(browser, platform, version)) && this.ignoreVersions.get(b).contains(version)) continue;
                    this.desktopBrowsers.add(b);
                }
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("Error parsing SauceREST JSON", e);
            }
        }

        protected Map<SauceLatest, Version> populateLatest() {
            HashMap<SauceLatest, Version> out = new HashMap<SauceLatest, Version>();
            for (SauceBrowser browser : this.desktopBrowsers) {
                if (out.containsKey(browser) && browser.version.compareTo((Version)out.get(browser)) <= 0) continue;
                out.remove(browser);
                out.put(new SauceLatest(browser.browser, browser.platform), browser.version);
            }
            for (SauceDevice device : this.deviceBrowsers) {
                if (out.containsKey(device) && device.version.compareTo((Version)out.get(device)) <= 0) continue;
                out.remove(device);
                out.put(new SauceLatest(device.device), device.version);
            }
            return out;
        }
    }

    public static enum Orientation {
        Any,
        Landscape,
        Portrait;

    }
}

