/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.qa.browserdriver.screenshot;

import com.assertthat.selenium_shutterbug.utils.image.ImageProcessor;
import com.assertthat.selenium_shutterbug.utils.web.Coordinates;
import com.assertthat.selenium_shutterbug.utils.web.ElementOutsideViewportException;
import edu.uci.qa.browserdriver.manager.ElementManager;
import edu.uci.qa.browserdriver.manager.WebDriverManager;
import edu.uci.qa.browserdriver.screenshot.ScreenshotProcessor;
import edu.uci.qa.browserdriver.screenshot.Shot;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;

public class Screenshot
extends Shot<Screenshot> {
    private final ElementManager browser;

    public <T extends WebDriverManager & ElementManager> Screenshot(T driver) {
        super(driver);
        this.browser = driver;
    }

    public Screenshot highlight(By locator) {
        return this.highlight(locator, Color.red, 3);
    }

    public Screenshot highlight(Coordinates coords) {
        this.image = ImageProcessor.highlight((BufferedImage)this.image, (Coordinates)coords, (Color)Color.red, (int)3);
        return this;
    }

    public Screenshot highlight(By locator, Color color) {
        return this.highlight(locator, color, 3);
    }

    public Screenshot highlight(By locator, Color color, int lineWidth) {
        return this.highlight((WebElement)this.browser.waitUntil(ExpectedConditions.visibilityOfElementLocated((By)locator)), color, lineWidth);
    }

    public Screenshot highlight(WebElement element) {
        return this.highlight(element, Color.red);
    }

    public Screenshot highlight(WebElement element, Color color) {
        return this.highlight(element, Color.red, 3);
    }

    public Screenshot highlight(WebElement element, Color color, int lineWidth) {
        this.image = ImageProcessor.highlight((BufferedImage)this.image, (Coordinates)new Coordinates(element), (Color)color, (int)lineWidth);
        return this;
    }

    public Screenshot highlightWithText(By locator, String text) {
        return this.highlightWithText(locator, Color.red, 3, text, Color.red, new Font("Serif", 1, 20));
    }

    public Screenshot highlightWithText(By locator, Color highlightColor, int lineWidth, String text, Color textColor, Font textFont) {
        this.highlight(locator, highlightColor, lineWidth);
        Coordinates coords = new Coordinates((WebElement)this.browser.waitUntil(ExpectedConditions.visibilityOfElementLocated((By)locator)));
        this.image = ImageProcessor.addText((BufferedImage)this.image, (int)coords.getX(), (int)(coords.getY() - textFont.getSize() / 2), (String)text, (Color)textColor, (Font)textFont);
        return this;
    }

    public Screenshot cover(Coordinates coords) {
        this.image = ScreenshotProcessor.cover(this.image, coords);
        return this;
    }

    public Screenshot cover(Coordinates coords, Color color) {
        this.image = ScreenshotProcessor.cover(this.image, coords, color);
        return this;
    }

    public Screenshot cover(By locator) {
        return this.cover((WebElement)this.browser.waitUntil(ExpectedConditions.visibilityOfElementLocated((By)locator)));
    }

    public Screenshot cover(WebElement element) {
        this.image = ScreenshotProcessor.cover(this.image, new Coordinates(element));
        return this;
    }

    public Screenshot cover(By locator, Color color) {
        return this.cover((WebElement)this.browser.waitUntil(ExpectedConditions.visibilityOfElementLocated((By)locator)), color);
    }

    public Screenshot cover(WebElement element, Color color) {
        this.image = ScreenshotProcessor.cover(this.image, new Coordinates(element), color);
        return this;
    }

    public Screenshot blur() {
        this.image = ImageProcessor.blur((BufferedImage)this.image);
        return this;
    }

    public Screenshot blur(By locator) {
        return this.blur((WebElement)this.browser.waitUntil(ExpectedConditions.visibilityOfElementLocated((By)locator)));
    }

    public Screenshot blur(WebElement element) {
        try {
            this.image = ImageProcessor.blurArea((BufferedImage)this.image, (Coordinates)new Coordinates(element));
        }
        catch (RasterFormatException rfe) {
            throw new ElementOutsideViewportException("Requested element is outside the viewport", (Throwable)rfe);
        }
        return this;
    }

    public Screenshot blurExcept(By locator) {
        return this.blurExcept((WebElement)this.browser.waitUntil(ExpectedConditions.visibilityOfElementLocated((By)locator)));
    }

    public Screenshot blurExcept(WebElement element) {
        try {
            this.image = ImageProcessor.blurExceptArea((BufferedImage)this.image, (Coordinates)new Coordinates(element));
        }
        catch (RasterFormatException rfe) {
            throw new ElementOutsideViewportException("Requested element is outside the viewport", (Throwable)rfe);
        }
        return this;
    }

    public Screenshot monochrome(By locator) {
        return this.monochrome((WebElement)this.browser.waitUntil(ExpectedConditions.visibilityOfElementLocated((By)locator)));
    }

    public Screenshot monochrome(WebElement element) {
        try {
            this.image = ImageProcessor.monochromeArea((BufferedImage)this.image, (Coordinates)new Coordinates(element));
        }
        catch (RasterFormatException rfe) {
            throw new ElementOutsideViewportException("Requested element is outside the viewport", (Throwable)rfe);
        }
        return this;
    }

    protected Screenshot self() {
        return this;
    }
}

