/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.qa.browserdriver.testing;

import com.saucelabs.common.Utils;
import edu.uci.qa.browserdriver.sauce.SauceLabs;
import edu.uci.qa.browserdriver.testing.BrowserProvider;
import edu.uci.qa.browserdriver.testing.BrowserTestWatcher;
import java.util.HashMap;
import org.junit.runner.Description;

public class SauceTestWatcher
extends BrowserTestWatcher {
    public SauceTestWatcher(BrowserProvider provider) {
        this(provider, false);
    }

    public SauceTestWatcher(BrowserProvider provider, boolean verboseMode) {
        super(provider, verboseMode);
    }

    protected void succeeded(Description description) {
        if (this.provider != null && this.provider.getBrowser().getSessionId() != null) {
            this.printSessionId(description);
            HashMap<String, Object> updates = new HashMap<String, Object>();
            updates.put("passed", true);
            Utils.addBuildNumberToUpdate(updates);
            SauceLabs.updateJobInfo(this.provider.getBrowser().getSessionId(), updates);
        }
    }

    private void printSessionId(Description description) {
        if (this.verboseMode) {
            String message = String.format("SauceOnDemandSessionID=%1$s job-name=%2$s.%3$s", this.provider.getBrowser().getSessionId(), description.getClassName(), description.getMethodName());
            System.out.println(message);
        }
    }

    protected void failed(Throwable e, Description description) {
        if (this.provider != null && this.provider.getBrowser().getSessionId() != null) {
            this.printSessionId(description);
            HashMap<String, Object> updates = new HashMap<String, Object>();
            updates.put("passed", false);
            Utils.addBuildNumberToUpdate(updates);
            SauceLabs.updateJobInfo(this.provider.getBrowser().getSessionId(), updates);
            if (this.verboseMode) {
                String authLink = SauceLabs.getPublicJobLink(this.provider.getBrowser().getSessionId());
                System.out.println("Job link: " + authLink);
            }
        }
    }
}

