/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.qa.browserdriver.utils;

import edu.uci.qa.browserdriver.BrowserDriver;
import edu.uci.qa.browserdriver.BrowserDriverException;
import edu.uci.qa.browserdriver.drivers.ChromeBrowserDriver;
import edu.uci.qa.browserdriver.drivers.EdgeBrowserDriver;
import edu.uci.qa.browserdriver.drivers.FirefoxBrowserDriver;
import edu.uci.qa.browserdriver.drivers.HtmlBrowserDriver;
import edu.uci.qa.browserdriver.drivers.InternetExplorerBrowserDriver;
import edu.uci.qa.browserdriver.drivers.OperaBrowserDriver;
import edu.uci.qa.browserdriver.drivers.PhantomBrowserDriver;
import edu.uci.qa.browserdriver.drivers.RemoteBrowserDriver;
import edu.uci.qa.browserdriver.drivers.SauceBrowserDriver;
import edu.uci.qa.browserdriver.utils.Family;
import edu.uci.qa.browserdriver.utils.Usable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public abstract class Browser
implements Usable {
    static final Map<Browser, Class<? extends BrowserDriver>> browserToClass = new HashMap<Browser, Class<? extends BrowserDriver>>();
    static final Map<Class<? extends BrowserDriver>, Browser> classToBrowser = new HashMap<Class<? extends BrowserDriver>, Browser>();
    private static final Map<String, Browser> nameMap = new HashMap<String, Browser>();
    public static Browser Firefox = Browser.createDesktopBrowser(FirefoxBrowserDriver.class, "Firefox", "ff", "marionette", "gecko");
    public static Browser Chrome = Browser.createDesktopBrowser(ChromeBrowserDriver.class, "Chrome", "c");
    public static Browser IE = Browser.createDesktopBrowser(InternetExplorerBrowserDriver.class, "Internet Explorer", "ie");
    public static Browser Edge = Browser.createDesktopBrowser(EdgeBrowserDriver.class, "MicrosoftEdge", "edge", "microsoft edge");
    public static Browser Opera = Browser.createDesktopBrowser(OperaBrowserDriver.class, "Opera", "opera blink");
    public static Browser Headless = Browser.createDesktopBrowser(HtmlBrowserDriver.class, "Headless", "htmlunitdriver");
    public static Browser Phantom = Browser.createDesktopBrowser(PhantomBrowserDriver.class, "PhantomJS", "js");
    public static Browser Safari = Browser.createDesktopBrowser(null, "Safari");
    public static Browser Remote = Browser.createRemoteBrowser(RemoteBrowserDriver.class, "Remote");
    public static Browser Sauce = Browser.createRemoteBrowser(SauceBrowserDriver.class, "Sauce", "saucelabs");
    public static Browser None = Browser.createBrowser(null, Family.NONE, new String[0]);
    public static ChromeHeadlessBrowser ChromeHeadless = ChromeHeadlessBrowser.create("ChromeHeadless");
    private final List<String> names;
    private final Class<? extends BrowserDriver> driver;
    private final Capabilities desiredCapabilities;

    private Browser(Class<? extends BrowserDriver> driver, String ... names) {
        if (driver != null) {
            this.desiredCapabilities = Browser.verify(driver);
            classToBrowser.put(driver, this);
        } else {
            this.desiredCapabilities = DesiredCapabilities.chrome();
        }
        for (String name : names) {
            nameMap.put(name.toLowerCase(), this);
        }
        this.names = Arrays.asList(names);
        this.driver = driver;
        browserToClass.put(this, driver);
    }

    public abstract Family family();

    public Capabilities desiredCapabilities() {
        return this.desiredCapabilities;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Browser && this.names.get(0).equals(((Browser)obj).names.get(0));
    }

    public int hashCode() {
        if (this.names != null && !this.names.isEmpty() && this.names.get(0) != null) {
            return this.names.get(0).hashCode();
        }
        return super.hashCode();
    }

    public String toString() {
        if (this.names != null && !this.names.isEmpty()) {
            return this.names.get(0);
        }
        return super.toString();
    }

    public final Class<? extends BrowserDriver> getDriver() {
        return this.driver;
    }

    public void unregister() {
        browserToClass.remove(this);
        Iterator<Map.Entry<Object, Browser>> itr = classToBrowser.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Class<? extends BrowserDriver>, Browser> entry = itr.next();
            if (!entry.getValue().equals(this)) continue;
            itr.remove();
        }
        itr = nameMap.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Object, Browser> name = itr.next();
            if (!name.getValue().equals(this)) continue;
            itr.remove();
        }
    }

    public static final Browser createBrowser(Class<? extends BrowserDriver> driver, Family family, String ... names) {
        if (family == null) {
            throw new IllegalArgumentException("Family cannot be null");
        }
        Browser out = classToBrowser.get(driver);
        if (out == null) {
            out = new GenericBrowser(driver, family, names);
        } else {
            for (String name : names) {
                nameMap.put(name.toLowerCase(), out);
            }
        }
        return out;
    }

    public static final Browser createDesktopBrowser(Class<? extends BrowserDriver> driver, String ... names) {
        Browser out = classToBrowser.get(driver);
        if (out == null) {
            out = new DesktopBrowser(driver, names);
        } else {
            for (String name : names) {
                nameMap.put(name.toLowerCase(), out);
            }
        }
        return out;
    }

    public static final Browser createRemoteBrowser(Class<? extends BrowserDriver> driver, String ... names) {
        Browser out = classToBrowser.get(driver);
        if (out == null) {
            out = new RemoteBrowser(driver, names);
        } else {
            for (String name : names) {
                nameMap.put(name.toLowerCase(), out);
            }
        }
        return out;
    }

    public static final Browser fromString(String name) {
        if (name == null) {
            return None;
        }
        Browser out = nameMap.get(name.toLowerCase());
        return out == null ? None : out;
    }

    public static final Browser fromClass(Class<? extends BrowserDriver> clazz) {
        Browser out = classToBrowser.get(clazz);
        return out == null ? None : out;
    }

    private static final Capabilities verify(Class<? extends BrowserDriver> driver) {
        try {
            Method method = Browser.getBrowserDriverClass(driver).getDeclaredMethod("desiredCapabilities", new Class[0]);
            method.setAccessible(true);
            return (Capabilities)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new BrowserDriverException(e.toString());
        }
    }

    private static Class<? extends BrowserDriver> getBrowserDriverClass(Class<? extends BrowserDriver> clss) {
        try {
            clss.getDeclaredMethod("desiredCapabilities", new Class[0]);
            return clss;
        }
        catch (NoSuchMethodException e) {
            if (clss.getSuperclass() != null && !clss.getSuperclass().equals(BrowserDriver.class) && BrowserDriver.class.isAssignableFrom(clss.getSuperclass())) {
                return Browser.getBrowserDriverClass(clss.getSuperclass().asSubclass(BrowserDriver.class));
            }
            throw new BrowserDriverException("Unable to find desiredCapabilities for " + clss.getName());
        }
    }

    public static class ChromeHeadlessBrowser
    extends DesktopBrowser {
        private boolean useGPU = false;
        private boolean debug = false;
        private int debugPort = 9222;
        private int width = 1024;
        private int height = 768;

        public static final ChromeHeadlessBrowser create(String ... names) {
            ChromeHeadlessBrowser out = (ChromeHeadlessBrowser)classToBrowser.get(ChromeHeadlessDriver.class);
            if (out == null) {
                out = new ChromeHeadlessBrowser(names);
            } else {
                for (String name : names) {
                    nameMap.put(name.toLowerCase(), out);
                }
            }
            return out;
        }

        public ChromeHeadlessBrowser(String ... names) {
            super(ChromeHeadlessDriver.class, names);
        }

        public void enableGPU(boolean value) {
            this.useGPU = value;
        }

        public void size(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public void enableDebug(boolean value) {
            this.debug = value;
        }

        public void debugPort(int value) {
            this.debugPort = value;
        }

        @Override
        public Capabilities desiredCapabilities() {
            DesiredCapabilities caps = (DesiredCapabilities)super.desiredCapabilities();
            ChromeOptions options = new ChromeOptions();
            options.addArguments(new String[]{"headless"});
            options.addArguments(new String[]{"window-size=" + this.width + "x" + this.height});
            if (!this.useGPU) {
                options.addArguments(new String[]{"disable-gpu"});
            }
            if (this.debug) {
                options.addArguments(new String[]{"remote-debugging-port=" + this.debugPort});
            }
            caps.setCapability("chromeOptions", (Object)options);
            return super.desiredCapabilities();
        }
    }

    public static class ChromeHeadlessDriver
    extends ChromeBrowserDriver {
        protected ChromeHeadlessDriver(Browser browser, Capabilities capabilities) {
            super(browser, capabilities);
        }
    }

    private static class GenericBrowser
    extends Browser {
        private final Family family;

        public GenericBrowser(Class<? extends BrowserDriver> driver, Family family, String ... names) {
            super((Class)driver, names);
            this.family = family;
        }

        @Override
        public Family family() {
            return this.family;
        }
    }

    private static class RemoteBrowser
    extends Browser {
        public RemoteBrowser(Class<? extends BrowserDriver> driver, String ... names) {
            super((Class)driver, names);
        }

        @Override
        public Family family() {
            return Family.REMOTE;
        }
    }

    private static class DesktopBrowser
    extends Browser {
        public DesktopBrowser(Class<? extends BrowserDriver> driver, String ... names) {
            super((Class)driver, names);
        }

        @Override
        public Family family() {
            return Family.DESKTOP;
        }
    }
}

