/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.qa.browserdriver.utils;

import edu.uci.qa.browserdriver.utils.Usable;
import org.openqa.selenium.WebDriverException;

public enum Device implements Usable
{
    Any(new String[0]){

        @Override
        public String deviceName() {
            return "";
        }

        @Override
        public String browserName() {
            return "";
        }

        @Override
        public String platformName() {
            return "";
        }

        @Override
        public String toString() {
            return "";
        }
    }
    ,
    Android(new String[0]){

        @Override
        public Device family() {
            return Android;
        }

        @Override
        public String platformName() {
            return "Android";
        }

        @Override
        public String browserName() {
            return "Browser";
        }

        @Override
        public String toString() {
            return "Android";
        }
    }
    ,
    AndroidPhone(new String[]{"Android Phone", "Phone", "androidphone"}){

        @Override
        public Device family() {
            return Android;
        }

        @Override
        public String deviceName() {
            return "Android Emulator";
        }
    }
    ,
    AndroidTablet(new String[]{"Android Tablet", "Tablet", "androidtablet"}){

        @Override
        public Device family() {
            return Android;
        }

        @Override
        public String deviceName() {
            return "Android Emulator";
        }
    }
    ,
    iOS(new String[0]){

        @Override
        public Device family() {
            return iOS;
        }

        @Override
        public String platformName() {
            return "iOS";
        }

        @Override
        public String browserName() {
            return "Safari";
        }

        @Override
        public String toString() {
            return "iOS";
        }
    }
    ,
    iPad(new String[]{"iPad"}){

        @Override
        public Device family() {
            return iOS;
        }

        @Override
        public String deviceName() {
            return "iPad Simulator";
        }
    }
    ,
    iPhone(new String[]{"iPhone"}){

        @Override
        public Device family() {
            return iOS;
        }

        @Override
        public String deviceName() {
            return "iPhone Simulator";
        }
    };

    private final String[] names;

    private Device(String ... names) {
        this.names = names;
    }

    public Device family() {
        return Any;
    }

    public String[] getNames() {
        return this.names;
    }

    public String browserName() {
        return this.family().browserName();
    }

    public String platformName() {
        return this.family().platformName();
    }

    public String deviceName() {
        return this.family().deviceName();
    }

    public static Device fromString(String name) {
        try {
            return Device.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            for (Device device : Device.values()) {
                for (String matcher : device.names) {
                    if (!name.toLowerCase().startsWith(matcher.toLowerCase())) continue;
                    return device;
                }
            }
            throw new WebDriverException("Unrecognized Device: " + name);
        }
    }

    public String toString() {
        if (this.names != null) {
            return this.names[0];
        }
        return super.toString();
    }
}

