/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.tacc.tapis.shareddb;

import edu.utexas.tacc.tapis.shared.exceptions.TapisException;
import edu.utexas.tacc.tapis.shared.i18n.MsgUtils;
import edu.utexas.tacc.tapis.shareddb.CreateDatabaseParameters;
import edu.utexas.tacc.tapis.shareddb.TapisDBUtils;
import edu.utexas.tacc.tapis.shareddb.datasource.TapisDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CreateDatabase {
    private static final Logger _log = LoggerFactory.getLogger(CreateDatabase.class);
    private static final String ADMIN_POOL = "adminPool";
    private static final int MAX_POOL_SIZE = 2;
    private final CreateDatabaseParameters _parms;

    public CreateDatabase(CreateDatabaseParameters parms) {
        if (parms == null) {
            String msg = MsgUtils.getMsg((String)"TAPIS_NULL_PARAMETER", (Object[])new Object[]{"CreateTenant", "parms"});
            _log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        this._parms = parms;
    }

    public static void main(String[] args) throws Exception {
        CreateDatabaseParameters parms = null;
        try {
            parms = new CreateDatabaseParameters(args);
        }
        catch (Exception e) {
            String msg = MsgUtils.getMsg((String)"TAPIS_SERVICE_INITIALIZATION_FAILED", (Object[])new Object[]{"CreateDatabase", e.getMessage()});
            _log.error(msg, (Throwable)e);
            throw e;
        }
        CreateDatabase cdb = new CreateDatabase(parms);
        cdb.create();
        System.out.println("\n--> Created database " + parms.tapisDB + " on host " + parms.dbHost + " with owner " + parms.dbUser + ".");
    }

    public void create() throws SQLException, TapisException {
        Connection adminConn = this.connectDB(this._parms.adminDB);
        this.createDB(adminConn);
        adminConn.close();
    }

    private Connection connectDB(String dbName) throws SQLException, TapisException {
        DataSource ds = TapisDataSource.getDataSource(this.getClass().getSimpleName(), ADMIN_POOL, TapisDBUtils.makeJdbcUrl(this._parms.dbHost, this._parms.dbPort, this._parms.adminDB), this._parms.dbUser, this._parms.dbPwd, 2, 0);
        Connection connection = ds.getConnection();
        return connection;
    }

    private void createDB(Connection adminConn) throws SQLException {
        adminConn.setAutoCommit(true);
        Statement stmt = adminConn.createStatement();
        String sql = "CREATE DATABASE " + this._parms.tapisDB + " WITH OWNER " + this._parms.dbUser + " ENCODING='UTF8' LC_COLLATE='en_US.utf8' LC_CTYPE='en_US.utf8'";
        stmt.execute(sql);
        stmt.close();
        adminConn.setAutoCommit(false);
    }
}

