/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.tacc.tapis.shareddb;

import edu.utexas.tacc.tapis.shared.exceptions.TapisException;
import edu.utexas.tacc.tapis.shared.i18n.MsgUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateDatabaseParameters {
    private static final Logger _log = LoggerFactory.getLogger(CreateDatabaseParameters.class);
    private static final String DB_USER = "tapis";
    private static final String DB_PWD = "password";
    private static final String DB_HOST = "localhost";
    private static final int DB_PORT = 5432;
    private static final String DFT_ADMIN_DB = "postgres";
    private static final String DFT_TAPIS_DB = "tapisdb";
    static final String DFT_CONNECTION_POOL_SIZE = "2";
    @Option(name="-admindb", required=false, metaVar="<existing db>", usage="existing admin db")
    public String adminDB = "postgres";
    @Option(name="-tapisdb", required=false, metaVar="<new db>", usage="tapis db to be created")
    public String tapisDB = "tapisdb";
    @Option(name="-dbuser", required=false, usage="DB user name")
    public String dbUser = "tapis";
    @Option(name="-dbpwd", required=false, usage="DB password")
    public String dbPwd = "password";
    @Option(name="-dbhost", required=false, usage="DB host")
    public String dbHost = "localhost";
    @Option(name="-dbport", required=false, usage="DB port")
    public int dbPort = 5432;
    @Option(name="-help", aliases={"--help"}, usage="display help information")
    public boolean help;

    public CreateDatabaseParameters(String[] args) throws TapisException {
        this.initializeParms(args);
        this.validateParms();
    }

    private void initializeParms(String[] args) throws TapisException {
        CmdLineParser parser;
        block5: {
            parser = new CmdLineParser((Object)this);
            parser.getProperties().withUsageWidth(120);
            try {
                parser.parseArgument(args);
            }
            catch (CmdLineException e) {
                if (this.help) break block5;
                int initialCapacity = 1024;
                StringWriter writer = new StringWriter(1024);
                writer.write("\n******* Input Parameter Error *******\n");
                writer.write(e.getMessage());
                writer.write("\n\n");
                writer.write("CreateTenant [options...]\n");
                ByteArrayOutputStream ostream = new ByteArrayOutputStream(1024);
                parser.printUsage((OutputStream)ostream);
                try {
                    writer.write(ostream.toString("UTF-8"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                writer.write("\n");
                throw new TapisException(writer.toString());
            }
        }
        if (this.help) {
            String s = "\nCreateTenant for creating a new tenant and its default submission queue.";
            System.out.println(s);
            System.out.println("\nCreateTenant [options...]\n");
            parser.printUsage((OutputStream)System.out);
            System.exit(0);
        }
    }

    private void validateParms() throws TapisException {
        if (StringUtils.isBlank((CharSequence)this.adminDB)) {
            String msg = MsgUtils.getMsg((String)"TAPIS_NULL_PARAMETER", (Object[])new Object[]{"validateParms", "adminDB"});
            _log.error(msg);
            throw new TapisException(msg);
        }
        if (StringUtils.isBlank((CharSequence)this.tapisDB)) {
            String msg = MsgUtils.getMsg((String)"TAPIS_NULL_PARAMETER", (Object[])new Object[]{"validateParms", "tapisDB"});
            _log.error(msg);
            throw new TapisException(msg);
        }
        if (StringUtils.isBlank((CharSequence)this.dbUser)) {
            String msg = MsgUtils.getMsg((String)"TAPIS_NULL_PARAMETER", (Object[])new Object[]{"validateParms", "dbUser"});
            _log.error(msg);
            throw new TapisException(msg);
        }
        if (StringUtils.isBlank((CharSequence)this.dbPwd)) {
            String msg = MsgUtils.getMsg((String)"TAPIS_NULL_PARAMETER", (Object[])new Object[]{"validateParms", "dbPwd"});
            _log.error(msg);
            throw new TapisException(msg);
        }
        if (StringUtils.isBlank((CharSequence)this.dbHost)) {
            String msg = MsgUtils.getMsg((String)"TAPIS_NULL_PARAMETER", (Object[])new Object[]{"validateParms", "dbHost"});
            _log.error(msg);
            throw new TapisException(msg);
        }
    }
}

