/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.tacc.tapis.shareddb.datasource;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import com.zaxxer.hikari.HikariDataSource;
import edu.utexas.tacc.tapis.shared.exceptions.runtime.TapisRuntimeException;
import edu.utexas.tacc.tapis.shared.i18n.MsgUtils;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariDSGenerator {
    private static final Logger _log = LoggerFactory.getLogger(HikariDSGenerator.class);
    public static final String TAPIS_DB_NAME = "tapisdb";
    public static final String TAPIS_SEC_DB_NAME = "tapissecdb";
    public static final String TAPIS_SCHEMA_NAME = "public";
    public static final String TAPIS_SEC_SCHEMA_NAME = "public";
    public static final String DEFAULT_DBMS_NAME = "postgresql";
    public static final String DEFAULT_DRIVER_CLASS_NAME = "org.postgresql.Driver";
    public static final boolean DEFAULT_AUTO_COMMIT = false;
    private String _dbmsName;
    private String _dbmsDriverName;

    public HikariDSGenerator() {
        this._dbmsName = DEFAULT_DBMS_NAME;
        this._dbmsDriverName = DEFAULT_DRIVER_CLASS_NAME;
    }

    public HikariDSGenerator(String dbmsName, String dbmsDriverName) {
        if (StringUtils.isBlank((CharSequence)dbmsName)) {
            String msg = MsgUtils.getMsg((String)"DB_NULL_DB_NAME", (Object[])new Object[0]);
            _log.error(msg);
            throw new TapisRuntimeException(msg);
        }
        if (StringUtils.isBlank((CharSequence)dbmsDriverName)) {
            String msg = MsgUtils.getMsg((String)"DB_NULL_DB_DRIVER_NAME", (Object[])new Object[0]);
            _log.error(msg);
            throw new TapisRuntimeException(msg);
        }
        this._dbmsName = dbmsName;
        this._dbmsDriverName = dbmsDriverName;
    }

    public HikariDataSource getDataSource() {
        HikariDataSource ds = new HikariDataSource();
        ds.setDriverClassName(this._dbmsDriverName);
        ds.setAutoCommit(false);
        return ds;
    }

    public HikariDataSource getDataSource(String appName, String poolName, String jdbcUrl, String user, String password, int maxPoolSize) {
        if (StringUtils.isBlank((CharSequence)appName)) {
            String msg = MsgUtils.getMsg((String)"TAPIS_NULL_PARAMETER", (Object[])new Object[]{"getDataSource", "appName"});
            _log.error(msg);
            throw new TapisRuntimeException(msg);
        }
        if (StringUtils.isBlank((CharSequence)poolName)) {
            String msg = MsgUtils.getMsg((String)"TAPIS_NULL_PARAMETER", (Object[])new Object[]{"getDataSource", "poolName"});
            _log.error(msg);
            throw new TapisRuntimeException(msg);
        }
        if (StringUtils.isBlank((CharSequence)jdbcUrl)) {
            String msg = MsgUtils.getMsg((String)"TAPIS_NULL_PARAMETER", (Object[])new Object[]{"getDataSource", "jdbcUrl"});
            _log.error(msg);
            throw new TapisRuntimeException(msg);
        }
        if (StringUtils.isBlank((CharSequence)user)) {
            String msg = MsgUtils.getMsg((String)"TAPIS_NULL_PARAMETER", (Object[])new Object[]{"getDataSource", "user"});
            _log.error(msg);
            throw new TapisRuntimeException(msg);
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            String msg = MsgUtils.getMsg((String)"TAPIS_NULL_PARAMETER", (Object[])new Object[]{"getDataSource", "password"});
            _log.error(msg);
            throw new TapisRuntimeException(msg);
        }
        if (maxPoolSize < 1) {
            String msg = MsgUtils.getMsg((String)"TAPIS_INVALID_PARAMETER", (Object[])new Object[]{"getDataSource", maxPoolSize});
            _log.error(msg);
            throw new TapisRuntimeException(msg);
        }
        HikariDataSource ds = this.getDataSource();
        ds.setPoolName(poolName);
        ds.setJdbcUrl(jdbcUrl);
        ds.addDataSourceProperty("user", (Object)user);
        ds.addDataSourceProperty("password", (Object)password);
        ds.addDataSourceProperty("ApplicationName", (Object)appName);
        ds.setMaximumPoolSize(maxPoolSize);
        return ds;
    }

    public HikariDSGenerator setReliabilityOptions(HikariDataSource ds) {
        ds.setLeakDetectionThreshold(1200000L);
        return this;
    }

    public HikariDSGenerator setMetricRegistry(HikariDataSource ds, int minutes, MetricReporterType reporterType) {
        if (minutes <= 0) {
            return this;
        }
        MetricRegistry metrics = new MetricRegistry();
        ds.setMetricRegistry((Object)metrics);
        switch (reporterType) {
            case SL4J: {
                Slf4jReporter reporter = Slf4jReporter.forRegistry((MetricRegistry)metrics).outputTo(_log).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
                reporter.start((long)minutes, TimeUnit.MINUTES);
                break;
            }
            case CONSOLE: {
                ConsoleReporter reporter = ConsoleReporter.forRegistry((MetricRegistry)metrics).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
                reporter.start((long)minutes, TimeUnit.MINUTES);
                break;
            }
        }
        return this;
    }

    public String getJdbcUrl(String host, int port, String db) {
        return "jdbc:" + this._dbmsName + "://" + host + ":" + port + "/" + db;
    }

    public static enum MetricReporterType {
        SL4J,
        CONSOLE;

    }
}

