/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.tacc.tapis.shareddb.datasource;

import com.p6spy.engine.spy.P6DataSource;
import com.zaxxer.hikari.HikariDataSource;
import edu.utexas.tacc.tapis.shared.exceptions.TapisException;
import edu.utexas.tacc.tapis.shared.exceptions.runtime.TapisRuntimeException;
import edu.utexas.tacc.tapis.shared.i18n.MsgUtils;
import edu.utexas.tacc.tapis.shareddb.datasource.HikariDSGenerator;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TapisDataSource {
    private static final Logger _log = LoggerFactory.getLogger(TapisDataSource.class);
    public static final String DFT_MIN_SERVER_VERSION = "11.4";
    private static P6DataSource _ds;

    public static synchronized DataSource getDataSource(String appName, String poolName, String jdbcUrl, String user, String password, int maxPoolSize, int meterMinutes) throws TapisException {
        if (_ds == null) {
            try {
                HikariDSGenerator dsgen = new HikariDSGenerator();
                HikariDataSource hikariDS = dsgen.getDataSource(appName, poolName, jdbcUrl, user, password, maxPoolSize);
                dsgen.setReliabilityOptions(hikariDS);
                dsgen.setMetricRegistry(hikariDS, meterMinutes, HikariDSGenerator.MetricReporterType.SL4J);
                _ds = new P6DataSource((DataSource)hikariDS);
            }
            catch (Exception e) {
                String msg = MsgUtils.getMsg((String)"DB_FAILED_DATASOURCE_CREATE", (Object[])new Object[]{poolName, maxPoolSize, user, jdbcUrl});
                _log.error(msg, (Throwable)e);
                throw new TapisException(msg, (Throwable)e);
            }
        }
        return _ds;
    }

    public static synchronized DataSource getDataSource() {
        return _ds;
    }

    public void setAssumeMinServerVersion(String version) {
        TapisDataSource.getHikariDataSource().addDataSourceProperty("assumeMinServerVersion", (Object)version);
    }

    public static synchronized void close() {
        if (_ds != null) {
            TapisDataSource.getHikariDataSource().close();
            _ds = null;
        }
    }

    private static HikariDataSource getHikariDataSource() throws TapisRuntimeException {
        try {
            return (HikariDataSource)_ds.unwrap(HikariDataSource.class);
        }
        catch (Exception e) {
            String msg = MsgUtils.getMsg((String)"DB_UNWRAP_DATASOURCE_ERROR", (Object[])new Object[]{e.getMessage()});
            _log.error(msg, (Throwable)e);
            throw new TapisRuntimeException(msg, (Throwable)e);
        }
    }
}

