/*
 * Decompiled with CFR 0.152.
 */
package eu.jonahbauer.android.preference.annotations.processor;

import com.squareup.javapoet.TypeName;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public final class StringUtils {
    private static final Pattern IDENTIFIER = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
    private static final Pattern FQCN = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*");

    public static boolean isJavaIdentifier(String string) {
        return IDENTIFIER.matcher(string).matches();
    }

    public static boolean isFQCN(String string) {
        return FQCN.matcher(string).matches();
    }

    public static String getMethodName(String preferenceName) {
        int index;
        while ((index = ((String)preferenceName).indexOf(95)) != -1) {
            if (index == ((String)preferenceName).length() - 1) {
                preferenceName = ((String)preferenceName).substring(0, index);
            }
            preferenceName = ((String)preferenceName).substring(0, index) + StringUtils.capitalize(((String)preferenceName).substring(index + 1));
        }
        return preferenceName;
    }

    public static String getGetterName(String methodName, TypeName type, boolean fluent) {
        return StringUtils.getGetterName(methodName, TypeName.BOOLEAN.equals((Object)type), fluent);
    }

    public static String getGetterName(String methodName, TypeMirror type, boolean fluent) {
        return StringUtils.getGetterName(methodName, type.getKind() == TypeKind.BOOLEAN, fluent);
    }

    public static String getGetterName(String methodName, boolean bool, boolean fluent) {
        if (fluent) {
            return methodName;
        }
        if (bool) {
            return "is" + StringUtils.capitalize(methodName);
        }
        return "get" + StringUtils.capitalize(methodName);
    }

    public static String getSetterName(String methodName, boolean fluent) {
        if (fluent) {
            return methodName;
        }
        return "set" + StringUtils.capitalize(methodName);
    }

    public static String capitalize(String str) {
        switch (str.length()) {
            case 0: {
                return "";
            }
            case 1: {
                return str.toUpperCase(Locale.ROOT);
            }
        }
        return str.substring(0, 1).toUpperCase(Locale.ROOT) + str.substring(1);
    }
}

