/*
 * Decompiled with CFR 0.152.
 */
package eu.jonahbauer.android.preference.annotations.processor.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import eu.jonahbauer.android.preference.annotations.Preference;
import eu.jonahbauer.android.preference.annotations.PreferenceGroup;
import eu.jonahbauer.android.preference.annotations.processor.ClassNames;
import eu.jonahbauer.android.preference.annotations.processor.StringUtils;
import eu.jonahbauer.android.preference.annotations.processor.model.Context;
import eu.jonahbauer.android.preference.annotations.processor.model.PreferenceEditorSpec;
import eu.jonahbauer.android.preference.annotations.processor.model.PreferenceKeysSpec;
import eu.jonahbauer.android.preference.annotations.processor.model.PreferenceSpec;
import java.util.ArrayList;
import javax.lang.model.element.Modifier;

public final class PreferenceGroupSpec {
    private final ClassName name;
    private final FieldSpec field;
    private final MethodSpec accessor;
    private final TypeSpec type;

    public static PreferenceGroupSpec create(Context context, int index, PreferenceGroup group) {
        if (!PreferenceGroupSpec.check(context, group)) {
            return null;
        }
        ClassName name = context.getRoot().nestedClass(group.name());
        TypeSpec.Builder type = TypeSpec.classBuilder((ClassName)name).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        CodeBlock.Builder constructorCode = CodeBlock.builder();
        Preference[] preferences = group.value();
        ArrayList<PreferenceSpec> preferenceSpecs = new ArrayList<PreferenceSpec>();
        for (int i = 0; i < preferences.length; ++i) {
            PreferenceSpec spec = PreferenceSpec.create(context, i, preferences[i]);
            if (spec == null) continue;
            preferenceSpecs.add(spec);
            spec.apply(type);
            String key = group.prefix() + preferences[i].name() + group.suffix();
            constructorCode.addStatement("$N = resources.getString($T.string.$N)", new Object[]{spec.getKey(), context.getR(), key});
        }
        type.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)ClassNames.RESOURCES, "resources", new Modifier[0]).addCode(constructorCode.build()).build());
        PreferenceKeysSpec.create(context, name, preferenceSpecs).apply(type);
        if (context.isEditor()) {
            PreferenceEditorSpec.create(context, name, preferenceSpecs).apply(type);
        }
        FieldSpec field = PreferenceGroupSpec.field(index, name);
        MethodSpec accessor = PreferenceGroupSpec.accessor(context, group.name(), field, context.getSharedPreferences());
        return new PreferenceGroupSpec(name, field, accessor, type.build());
    }

    public void apply(TypeSpec.Builder builder) {
        builder.addField(this.field).addMethod(this.accessor).addType(this.type);
    }

    private static boolean check(Context context, PreferenceGroup group) {
        if (!StringUtils.isJavaIdentifier(group.name())) {
            context.error("Illegal preference group name: %s", group.name());
            return false;
        }
        if (!group.prefix().isEmpty() && !StringUtils.isJavaIdentifier(group.prefix())) {
            context.error("Illegal preference group prefix: %s", group.prefix());
            return false;
        }
        if (!group.suffix().isEmpty() && !group.suffix().matches("\\p{javaJavaIdentifierPart}+")) {
            context.error("Illegal preference group suffix: %s", group.suffix());
            return false;
        }
        return true;
    }

    private static FieldSpec field(int index, ClassName name) {
        return FieldSpec.builder((TypeName)name, (String)("group$" + index), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).build();
    }

    private static MethodSpec accessor(Context context, String name, FieldSpec field, FieldSpec sharedPreferences) {
        return MethodSpec.methodBuilder((String)StringUtils.getGetterName(name, field.type, context.isFluent())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(field.type).addCode(CodeBlock.builder().beginControlFlow("if ($N == null)", new Object[]{sharedPreferences}).addStatement("throw new $T($S)", new Object[]{ClassNames.ILLEGAL_STATE_EXCEPTION, "Preferences have not yet been initialized."}).endControlFlow().addStatement("return $N", new Object[]{field}).build()).build();
    }

    public PreferenceGroupSpec(ClassName name, FieldSpec field, MethodSpec accessor, TypeSpec type) {
        this.name = name;
        this.field = field;
        this.accessor = accessor;
        this.type = type;
    }

    public ClassName getName() {
        return this.name;
    }

    public FieldSpec getField() {
        return this.field;
    }

    public MethodSpec getAccessor() {
        return this.accessor;
    }

    public TypeSpec getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PreferenceGroupSpec)) {
            return false;
        }
        PreferenceGroupSpec other = (PreferenceGroupSpec)o;
        ClassName this$name = this.getName();
        ClassName other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        FieldSpec this$field = this.getField();
        FieldSpec other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        MethodSpec this$accessor = this.getAccessor();
        MethodSpec other$accessor = other.getAccessor();
        if (this$accessor == null ? other$accessor != null : !this$accessor.equals(other$accessor)) {
            return false;
        }
        TypeSpec this$type = this.getType();
        TypeSpec other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ClassName $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        FieldSpec $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        MethodSpec $accessor = this.getAccessor();
        result = result * 59 + ($accessor == null ? 43 : $accessor.hashCode());
        TypeSpec $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "PreferenceGroupSpec(name=" + this.getName() + ", field=" + this.getField() + ", accessor=" + this.getAccessor() + ", type=" + this.getType() + ")";
    }
}

