/*
 * Decompiled with CFR 0.152.
 */
package eu.jonahbauer.android.preference.annotations.processor.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import eu.jonahbauer.android.preference.annotations.processor.TypeUtils;
import eu.jonahbauer.android.preference.annotations.processor.model.Context;
import eu.jonahbauer.android.preference.annotations.processor.model.PreferenceSpec;
import java.util.List;
import javax.lang.model.element.Modifier;

public final class PreferenceKeysSpec {
    private final FieldSpec field;
    private final MethodSpec accessor;
    private final TypeSpec type;

    public static PreferenceKeysSpec create(Context context, ClassName parent, List<PreferenceSpec> preferences) {
        ClassName name = parent.nestedClass("Keys");
        TypeSpec.Builder type = TypeSpec.classBuilder((ClassName)name).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        for (PreferenceSpec preference : preferences) {
            type.addMethod(TypeUtils.getter(preference.getName(), preference.getKey(), context.isFluent()));
        }
        FieldSpec field = FieldSpec.builder((TypeName)name, (String)"keys", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T()", new Object[]{name}).build();
        MethodSpec accessor = TypeUtils.getter("keys", field, context.isFluent());
        return new PreferenceKeysSpec(field, accessor, type.build());
    }

    public void apply(TypeSpec.Builder builder) {
        builder.addField(this.field).addMethod(this.accessor).addType(this.type);
    }

    public PreferenceKeysSpec(FieldSpec field, MethodSpec accessor, TypeSpec type) {
        this.field = field;
        this.accessor = accessor;
        this.type = type;
    }

    public FieldSpec getField() {
        return this.field;
    }

    public MethodSpec getAccessor() {
        return this.accessor;
    }

    public TypeSpec getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PreferenceKeysSpec)) {
            return false;
        }
        PreferenceKeysSpec other = (PreferenceKeysSpec)o;
        FieldSpec this$field = this.getField();
        FieldSpec other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        MethodSpec this$accessor = this.getAccessor();
        MethodSpec other$accessor = other.getAccessor();
        if (this$accessor == null ? other$accessor != null : !this$accessor.equals(other$accessor)) {
            return false;
        }
        TypeSpec this$type = this.getType();
        TypeSpec other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FieldSpec $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        MethodSpec $accessor = this.getAccessor();
        result = result * 59 + ($accessor == null ? 43 : $accessor.hashCode());
        TypeSpec $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "PreferenceKeysSpec(field=" + this.getField() + ", accessor=" + this.getAccessor() + ", type=" + this.getType() + ")";
    }
}

