/*
 * Decompiled with CFR 0.152.
 */
package eu.jonahbauer.android.preference.annotations.processor.model;

import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import eu.jonahbauer.android.preference.annotations.Preference;
import eu.jonahbauer.android.preference.annotations.processor.TypeUtils;
import eu.jonahbauer.android.preference.annotations.processor.model.Context;
import eu.jonahbauer.android.preference.annotations.serializer.EnumPreferenceSerializer;
import eu.jonahbauer.android.preference.annotations.serializer.PreferenceSerializer;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

public final class SerializerSpec {
    private final TypeMirror deserializedType;
    private final TypeMirror serializedType;
    private final FieldSpec serializer;

    public static SerializerSpec create(Context context, int index, Preference preference) {
        TypeMirror declaredType = TypeUtils.mirror(preference, Preference::type);
        TypeMirror serializerRawType = TypeUtils.mirror(preference, Preference::serializer);
        if (context.isSame(serializerRawType, PreferenceSerializer.class, new Class[0])) {
            if (context.isEnum(declaredType)) {
                serializerRawType = context.getType(EnumPreferenceSerializer.class, new Class[0]);
            } else {
                if (context.isSame(declaredType, Set.class, new Class[0])) {
                    return new SerializerSpec(context.getType(Set.class, String.class));
                }
                return new SerializerSpec(declaredType);
            }
        }
        if (serializerRawType == null) {
            context.error("No serializer for preference %s", preference.name());
            return new SerializerSpec(declaredType);
        }
        if (!(serializerRawType instanceof DeclaredType)) {
            context.error("Invalid serializer type %s", serializerRawType);
            return new SerializerSpec(declaredType);
        }
        DeclaredType serializerType = SerializerSpec.withTypeArguments(context, (DeclaredType)serializerRawType, declaredType);
        TypeName serializerTypeName = TypeName.get((TypeMirror)serializerType);
        DeclaredType serializerInt = SerializerSpec.findSerializerType(context, serializerType);
        if (SerializerSpec.check(context, preference, serializerInt)) {
            assert (serializerInt != null);
        } else {
            return new SerializerSpec(declaredType);
        }
        TypeMirror serializedType = context.tryUnbox(serializerInt.getTypeArguments().get(1));
        TypeMirror deserializedType = context.tryUnbox(serializerInt.getTypeArguments().get(0));
        Boolean constructor = SerializerSpec.hasClassConstructor(context, serializerType);
        if (constructor == null) {
            context.error("Could not find a suitable constructor in serializer class " + serializerType + ".", new Object[0]);
            return new SerializerSpec(declaredType);
        }
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)serializerTypeName, (String)("serializer$" + index), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        if (constructor.booleanValue()) {
            builder.initializer("new $T($T.class)", new Object[]{serializerTypeName, context.tryBox(declaredType)});
        } else {
            builder.initializer("new $T()", new Object[]{serializerTypeName});
        }
        return new SerializerSpec(deserializedType, serializedType, builder.build());
    }

    private SerializerSpec(TypeMirror type) {
        this(type, type, null);
    }

    private static DeclaredType withTypeArguments(Context context, DeclaredType serializer, TypeMirror declaredType) {
        List<? extends TypeMirror> typeArguments = (serializer = (DeclaredType)serializer.asElement().asType()).getTypeArguments();
        if (typeArguments.size() == 1) {
            TypeMirror boxedType = context.tryBox(declaredType);
            return context.getTypeUtils().getDeclaredType((TypeElement)serializer.asElement(), boxedType);
        }
        return serializer;
    }

    private static DeclaredType findSerializerType(Context context, TypeMirror type) {
        Types typeUtils = context.getTypeUtils();
        if (context.isSame(type, PreferenceSerializer.class, new Class[0])) {
            return (DeclaredType)type;
        }
        for (TypeMirror typeMirror : typeUtils.directSupertypes(type)) {
            DeclaredType serializerType;
            if (context.isSame(typeMirror, Object.class, new Class[0]) || (serializerType = SerializerSpec.findSerializerType(context, typeMirror)) == null) continue;
            return serializerType;
        }
        return null;
    }

    private static boolean check(Context context, Preference preference, DeclaredType serializer) {
        if (serializer == null) {
            context.error("No serializer for preference %s", preference.name());
            return false;
        }
        if (serializer.getTypeArguments().size() != 2) {
            context.error("Unable to identify type arguments of serializer %s for preference %s", serializer, preference.name());
            return false;
        }
        return true;
    }

    private static Boolean hasClassConstructor(Context context, DeclaredType serializer) {
        for (Element element : serializer.asElement().getEnclosedElements()) {
            TypeMirror param;
            if (element.getKind() != ElementKind.CONSTRUCTOR) continue;
            ExecutableType constructor = (ExecutableType)element.asType();
            List<? extends TypeMirror> parameters = constructor.getParameterTypes();
            if (parameters.size() == 0) {
                return false;
            }
            if (parameters.size() != 1 || !context.isSame(param = parameters.get(0), Class.class, new Class[0])) continue;
            return true;
        }
        context.error("No suitable constructor found for serializer %s", serializer);
        return null;
    }

    public TypeMirror getDeserializedType() {
        return this.deserializedType;
    }

    public TypeMirror getSerializedType() {
        return this.serializedType;
    }

    public FieldSpec getSerializer() {
        return this.serializer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SerializerSpec)) {
            return false;
        }
        SerializerSpec other = (SerializerSpec)o;
        TypeMirror this$deserializedType = this.getDeserializedType();
        TypeMirror other$deserializedType = other.getDeserializedType();
        if (this$deserializedType == null ? other$deserializedType != null : !((Object)this$deserializedType).equals(other$deserializedType)) {
            return false;
        }
        TypeMirror this$serializedType = this.getSerializedType();
        TypeMirror other$serializedType = other.getSerializedType();
        if (this$serializedType == null ? other$serializedType != null : !((Object)this$serializedType).equals(other$serializedType)) {
            return false;
        }
        FieldSpec this$serializer = this.getSerializer();
        FieldSpec other$serializer = other.getSerializer();
        return !(this$serializer == null ? other$serializer != null : !this$serializer.equals(other$serializer));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TypeMirror $deserializedType = this.getDeserializedType();
        result = result * 59 + ($deserializedType == null ? 43 : ((Object)$deserializedType).hashCode());
        TypeMirror $serializedType = this.getSerializedType();
        result = result * 59 + ($serializedType == null ? 43 : ((Object)$serializedType).hashCode());
        FieldSpec $serializer = this.getSerializer();
        result = result * 59 + ($serializer == null ? 43 : $serializer.hashCode());
        return result;
    }

    public String toString() {
        return "SerializerSpec(deserializedType=" + this.getDeserializedType() + ", serializedType=" + this.getSerializedType() + ", serializer=" + this.getSerializer() + ")";
    }

    private SerializerSpec(TypeMirror deserializedType, TypeMirror serializedType, FieldSpec serializer) {
        this.deserializedType = deserializedType;
        this.serializedType = serializedType;
        this.serializer = serializer;
    }
}

