/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.blueprint;

import com.github.dynamicextensionsalfresco.annotations.AlfrescoPlatform;
import java.io.IOException;
import java.util.Map;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.util.VersionNumber;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.StringUtils;

class AlfrescoPlatformBeanDefinitionScanner
extends ClassPathBeanDefinitionScanner {
    private final Descriptor descriptor;

    public AlfrescoPlatformBeanDefinitionScanner(BeanDefinitionRegistry registry, Descriptor descriptor) {
        super(registry, true);
        this.descriptor = descriptor;
    }

    protected boolean isCandidateComponent(MetadataReader metadataReader) throws IOException {
        return super.isCandidateComponent(metadataReader) && this.matchesAlfrescoVersion(metadataReader);
    }

    private boolean matchesAlfrescoVersion(MetadataReader metadataReader) {
        boolean matches = true;
        AnnotationMetadata metadata = metadataReader.getAnnotationMetadata();
        if (metadata.isAnnotated(AlfrescoPlatform.class.getName())) {
            Map alfrescoVersion = metadata.getAnnotationAttributes(AlfrescoPlatform.class.getName());
            String minVersion = (String)alfrescoVersion.get("minVersion");
            String maxVersion = (String)alfrescoVersion.get("maxVersion");
            VersionNumber versionNumber = this.descriptor.getVersionNumber();
            if (StringUtils.hasText((String)minVersion) && versionNumber.compareTo(new VersionNumber(minVersion)) < 0) {
                matches = false;
            } else if (StringUtils.hasText((String)maxVersion) && versionNumber.compareTo(new VersionNumber(maxVersion)) > 0) {
                matches = false;
            }
        }
        return matches;
    }
}

