/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.blueprint;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.springframework.extensions.webscripts.ScriptContent;
import org.springframework.util.Assert;

class BundleScriptContent
implements ScriptContent {
    private final URL url;
    private final String path;
    private final boolean secure;
    private final String encoding;

    BundleScriptContent(URL url, String path, boolean secure, String encoding) {
        Assert.notNull((Object)url, (String)"URL cannot be null.");
        Assert.hasText((String)encoding, (String)"Encoding cannot be empty.");
        this.url = url;
        this.path = path;
        this.secure = secure;
        this.encoding = encoding;
    }

    protected URL getUrl() {
        return this.url;
    }

    protected String getEncoding() {
        return this.encoding;
    }

    public InputStream getInputStream() {
        try {
            return this.getUrl().openStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Reader getReader() {
        try {
            return new InputStreamReader(this.getUrl().openStream(), this.getEncoding());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getPathDescription() {
        return this.path;
    }

    public boolean isCachable() {
        return true;
    }

    public boolean isSecure() {
        return this.secure;
    }
}

