/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.blueprint;

import com.github.dynamicextensionsalfresco.blueprint.BundleScriptContent;
import java.net.URL;
import org.osgi.framework.Bundle;
import org.springframework.extensions.webscripts.ScriptContent;
import org.springframework.extensions.webscripts.ScriptLoader;
import org.springframework.util.Assert;

class BundleScriptLoader
implements ScriptLoader {
    private static final String DEFAULT_SCRIPT_ENCODING = "ISO-8859-1";
    private final Bundle bundle;
    private boolean secure;
    private String encoding;

    BundleScriptLoader(Bundle bundle) {
        Assert.notNull((Object)bundle, (String)"Bundle cannot be null.");
        this.bundle = bundle;
    }

    protected Bundle getBundle() {
        return this.bundle;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    protected boolean isSecure() {
        return this.secure;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected String getEncoding() {
        return this.encoding;
    }

    public ScriptContent getScript(String path) {
        BundleScriptContent scriptContent = null;
        try {
            URL url = null;
            if (this.getBundle().getState() == 32) {
                url = this.getBundle().getEntry(path);
            }
            if (url != null) {
                scriptContent = new BundleScriptContent(url, path, this.secure, DEFAULT_SCRIPT_ENCODING);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return scriptContent;
    }
}

