/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.blueprint;

import com.github.dynamicextensionsalfresco.blueprint.BundleScriptLoader;
import com.github.dynamicextensionsalfresco.blueprint.BundleTemplateLoader;
import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.dom4j.Document;
import org.osgi.framework.Bundle;
import org.springframework.extensions.surf.util.Pair;
import org.springframework.extensions.webscripts.ScriptLoader;
import org.springframework.extensions.webscripts.Store;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BundleStore
implements Store {
    private static final int LAST_MODIFIED_UNKNOWN = -1;
    private final Bundle bundle;
    private boolean secure;
    private final BundleTemplateLoader bundleTemplateLoader;
    private final BundleScriptLoader bundleScriptLoader;

    public BundleStore(Bundle bundle) {
        Assert.notNull((Object)bundle, (String)"Bundle cannot be null.");
        this.bundle = bundle;
        this.bundleTemplateLoader = new BundleTemplateLoader(bundle);
        this.bundleScriptLoader = new BundleScriptLoader(bundle);
    }

    protected Bundle getBundle() {
        return this.bundle;
    }

    public void init() {
    }

    public boolean exists() {
        return true;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
        this.bundleScriptLoader.setSecure(secure);
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean hasDocument(String documentPath) throws IOException {
        URL url;
        if (!documentPath.startsWith("/")) {
            documentPath = String.format("/%s", documentPath);
        }
        return (url = this.getBundle().getEntry(documentPath)) != null;
    }

    public InputStream getDocument(String documentPath) throws IOException {
        URL url = this.getBundle().getEntry(documentPath);
        return url.openStream();
    }

    public long lastModified(String documentPath) throws IOException {
        long lastModified = -1L;
        URL url = this.getBundle().getEntry(documentPath);
        if (url != null) {
            lastModified = url.openConnection().getLastModified();
        }
        return lastModified;
    }

    public String getBasePath() {
        return String.format("%s:", this.bundle.getSymbolicName());
    }

    public String[] getAllDocumentPaths() {
        try {
            return this.getDocumentPaths("/", true, "*");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String[] getDocumentPaths(String path, boolean includeSubPaths, String documentPattern) throws IOException {
        if (!StringUtils.hasText((String)path)) {
            path = "/";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        Enumeration entries = this.getBundle().findEntries(path, documentPattern, includeSubPaths);
        ArrayList<String> documentPaths = new ArrayList<String>();
        if (entries != null) {
            while (entries.hasMoreElements()) {
                URL url = (URL)entries.nextElement();
                try {
                    documentPaths.add(this.processDocumentPath(url.toURI().getPath()));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return documentPaths.toArray(new String[documentPaths.size()]);
    }

    private String processDocumentPath(String path) {
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    public String[] getDocumentPaths(String path, String filePathPattern) throws IOException {
        return this.getDocumentPaths(path, false, filePathPattern);
    }

    public String[] getDescriptionDocumentPaths() throws IOException {
        return this.getDocumentPaths("/", true, "*.desc.xml");
    }

    public String[] getScriptDocumentPaths(WebScript script) throws IOException {
        String pattern = String.format("%s.*", script.getDescription().getId());
        return this.getDocumentPaths("/", false, pattern);
    }

    public TemplateLoader getTemplateLoader() {
        return this.bundleTemplateLoader;
    }

    public ScriptLoader getScriptLoader() {
        return this.bundleScriptLoader;
    }

    public void createDocument(String documentPath, String content) throws IOException {
        throw new UnsupportedOperationException("Not supported");
    }

    public void updateDocument(String documentPath, String content) throws IOException {
        throw new UnsupportedOperationException("Not supported");
    }

    public boolean removeDocument(String documentPath) throws IOException {
        throw new UnsupportedOperationException("Not supported");
    }

    public void createDocuments(List<Pair<String, Document>> arg0) throws IOException {
    }

    public boolean isReadOnly() {
        return true;
    }
}

