/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.blueprint;

import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.osgi.framework.Bundle;
import org.springframework.util.Assert;

class BundleTemplateLoader
implements TemplateLoader {
    private static final int LAST_MODIFIED_UNKNOWN = -1;
    private final Bundle bundle;

    BundleTemplateLoader(Bundle bundle) {
        Assert.notNull((Object)bundle, (String)"Bundle cannot be null.");
        this.bundle = bundle;
    }

    protected Bundle getBundle() {
        return this.bundle;
    }

    public Object findTemplateSource(String name) throws IOException {
        URL templateSource = null;
        if (this.getBundle().getState() == 32) {
            templateSource = this.getBundle().getEntry(name);
        }
        return templateSource;
    }

    public long getLastModified(Object templateSource) {
        long lastModified = -1L;
        if (templateSource instanceof URL) {
            try {
                URL url = (URL)templateSource;
                lastModified = url.openConnection().getLastModified();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return lastModified;
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        InputStreamReader reader = null;
        if (templateSource instanceof URL) {
            URL url = (URL)templateSource;
            reader = new InputStreamReader(url.openStream(), encoding);
        }
        return reader;
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
    }
}

