/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.blueprint;

import java.util.Collection;
import org.eclipse.gemini.blueprint.context.support.OsgiBundleXmlApplicationContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

class BundleUtils {
    public static final String DM_CORE_ID = "spring.osgi.core.bundle.id";
    public static final String DM_CORE_TS = "spring.osgi.core.bundle.timestamp";

    private BundleUtils() {
    }

    public static Bundle getDMCoreBundle(BundleContext ctx) {
        Object service;
        ServiceReference ref = ctx.getServiceReference(PackageAdmin.class.getName());
        if (ref != null && (service = ctx.getService(ref)) instanceof PackageAdmin) {
            PackageAdmin pa = (PackageAdmin)service;
            return pa.getBundle(OsgiBundleXmlApplicationContext.class);
        }
        return null;
    }

    public static String createNamespaceFilter(BundleContext ctx) {
        Bundle bnd = BundleUtils.getDMCoreBundle(ctx);
        if (bnd != null) {
            return "(|(spring.osgi.core.bundle.id=" + bnd.getBundleId() + ")(" + DM_CORE_TS + "=" + bnd.getLastModified() + "))";
        }
        return "";
    }

    public static <TService> TService getService(BundleContext bundleContext, Class<TService> clazz) {
        return BundleUtils.getService(bundleContext, clazz, null);
    }

    public static <TService> TService getService(BundleContext bundleContext, Class<TService> clazz, String filter) {
        try {
            Collection serviceRefs = bundleContext.getServiceReferences(clazz, filter);
            if (serviceRefs.isEmpty()) {
                throw new IllegalStateException(String.format("Cannot obtain '%s' service reference from bundle context.", clazz.getName()));
            }
            return (TService)bundleContext.getService((ServiceReference)serviceRefs.iterator().next());
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Argument 'filter' is not valid", e);
        }
    }
}

