/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.blueprint;

import com.github.dynamicextensionsalfresco.BeanNames;
import com.github.dynamicextensionsalfresco.actions.AnnotationBasedActionRegistrar;
import com.github.dynamicextensionsalfresco.aop.DynamicExtensionsAdvisorAutoProxyCreator;
import com.github.dynamicextensionsalfresco.blueprint.AlfrescoPlatformBeanDefinitionScanner;
import com.github.dynamicextensionsalfresco.blueprint.BundleStore;
import com.github.dynamicextensionsalfresco.blueprint.BundleUtils;
import com.github.dynamicextensionsalfresco.blueprint.CompositeEntityResolver;
import com.github.dynamicextensionsalfresco.blueprint.CompositeNamespaceHandlerResolver;
import com.github.dynamicextensionsalfresco.blueprint.OsgiServiceRegistrar;
import com.github.dynamicextensionsalfresco.event.Event;
import com.github.dynamicextensionsalfresco.event.EventBus;
import com.github.dynamicextensionsalfresco.event.events.SpringContextException;
import com.github.dynamicextensionsalfresco.messages.MessagesRegistrar;
import com.github.dynamicextensionsalfresco.metrics.SpringTimer;
import com.github.dynamicextensionsalfresco.models.M2ModelResourceListProvider;
import com.github.dynamicextensionsalfresco.models.RepositoryModelRegistrar;
import com.github.dynamicextensionsalfresco.osgi.webscripts.SearchPathRegistry;
import com.github.dynamicextensionsalfresco.osgi.webscripts.SearchPathRegistryManager;
import com.github.dynamicextensionsalfresco.policy.AnnotationBasedBehaviourRegistrar;
import com.github.dynamicextensionsalfresco.policy.DefaultBehaviourProxyFactory;
import com.github.dynamicextensionsalfresco.policy.ProxyPolicyComponentFactoryBean;
import com.github.dynamicextensionsalfresco.resources.DefaultBootstrapService;
import com.github.dynamicextensionsalfresco.resources.ResourceHelper;
import com.github.dynamicextensionsalfresco.schedule.ScheduledTaskRegistrar;
import com.github.dynamicextensionsalfresco.schedule.quartz.QuartzTaskScheduler;
import com.github.dynamicextensionsalfresco.schedule.quartz2.Quartz2TaskScheduler;
import com.github.dynamicextensionsalfresco.web.WebResourcesRegistrar;
import com.github.dynamicextensionsalfresco.webscripts.AnnotationWebScriptBuilder;
import com.github.dynamicextensionsalfresco.webscripts.AnnotationWebScriptRegistrar;
import com.github.dynamicextensionsalfresco.webscripts.MessageConverterRegistry;
import com.github.dynamicextensionsalfresco.webscripts.WebScriptUriRegistry;
import com.github.dynamicextensionsalfresco.webscripts.arguments.HandlerMethodArgumentsResolver;
import com.github.dynamicextensionsalfresco.webscripts.arguments.StringValueConverter;
import com.github.dynamicextensionsalfresco.workflow.WorkflowDefinitionRegistrar;
import com.github.dynamicextensionsalfresco.workflow.activiti.WorkflowTaskRegistrar;
import com.github.dynamicextensionsalfresco.workflow.activiti.WorkflowTaskRegistry;
import com.springsource.util.osgi.manifest.BundleManifest;
import com.springsource.util.osgi.manifest.BundleManifestFactory;
import com.springsource.util.osgi.manifest.ImportedPackage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import java.util.stream.Collectors;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.util.VersionNumber;
import org.eclipse.gemini.blueprint.context.support.OsgiBundleXmlApplicationContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.DefaultNamespaceHandlerResolver;
import org.springframework.beans.factory.xml.DelegatingEntityResolver;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.extensions.webscripts.TemplateProcessor;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.xml.sax.EntityResolver;

public abstract class DynamicExtensionsApplicationContextBase
extends OsgiBundleXmlApplicationContext {
    private static final Logger log = LoggerFactory.getLogger(DynamicExtensionsApplicationContextBase.class);
    private final boolean hasXmlConfiguration;
    public static final String SPRING_CONFIGURATION_HEADER = "Alfresco-Spring-Configuration";
    public static final String ALFRESCO_DYNAMIC_EXTENSION_HEADER = "Alfresco-Dynamic-Extension";
    private static final String HOST_APPLICATION_ALFRESCO_FILTER = "(hostApplication=alfresco)";
    public static BeanDefinitionBuilderCustomizer beanAutowireByType = new BeanDefinitionBuilderCustomizer(){

        @Override
        public void customize(BeanDefinitionBuilder builder) {
            builder.setAutowireMode(2);
        }
    };
    public static BeanDefinitionBuilderCustomizer beanAutowireByName = new BeanDefinitionBuilderCustomizer(){

        @Override
        public void customize(BeanDefinitionBuilder builder) {
            builder.setAutowireMode(1);
        }
    };

    public DynamicExtensionsApplicationContextBase(String[] configurationLocations, ApplicationContext parent) {
        super(configurationLocations, parent);
        this.hasXmlConfiguration = !ObjectUtils.isEmpty((Object[])configurationLocations);
    }

    @NotNull
    protected DefaultListableBeanFactory createBeanFactory() {
        VersionNumber version = this.getService(DescriptorService.class).getServerDescriptor().getVersionNumber();
        return this.createVersionSpecificBeanFactory(version);
    }

    protected abstract DefaultListableBeanFactory createVersionSpecificBeanFactory(VersionNumber var1);

    protected void loadBeanDefinitions(@NotNull DefaultListableBeanFactory beanFactory) throws IOException {
        if (beanFactory == null) {
            throw new IllegalArgumentException("beanFactory is null");
        }
        boolean isAlfrescoDynamicExtension = this.isAlfrescoDynamicExtension();
        if (this.hasSpringConfigurationHeader()) {
            if (this.hasXmlConfiguration() && log.isWarnEnabled()) {
                log.warn("Spring XML configuration at /META-INF/spring will be ignored due to the presence of the 'Alfresco-Spring-Configuration' header.");
            }
            this.scanPackages(beanFactory, this.getSpringConfigurationPackages());
        } else if (this.hasXmlConfiguration()) {
            try {
                super.loadBeanDefinitions(beanFactory);
            }
            catch (BeanDefinitionParsingException ex) {
                log.warn("Error parsing bean definitions.", (Throwable)ex);
            }
        } else if (isAlfrescoDynamicExtension) {
            this.scanPackages(beanFactory, this.getBundleExportPackages());
        }
        if (isAlfrescoDynamicExtension) {
            this.registerInfrastructureBeans(beanFactory);
        }
    }

    protected void initBeanDefinitionReader(@NotNull XmlBeanDefinitionReader beanDefinitionReader) {
        if (beanDefinitionReader == null) {
            throw new IllegalArgumentException("beanDefinitionReader is null");
        }
        beanDefinitionReader.setResourceLoader((ResourceLoader)this);
        beanDefinitionReader.setNamespaceHandlerResolver((NamespaceHandlerResolver)new CompositeNamespaceHandlerResolver(new NamespaceHandlerResolver[]{this.getOsgiNamespaceHandlerResolver(), new DefaultNamespaceHandlerResolver(this.getClassLoader()), this.getHostNamespaceHandlerResolver()}));
        beanDefinitionReader.setEntityResolver((EntityResolver)new CompositeEntityResolver(new EntityResolver[]{this.getOsgiEntityResolver(), new DelegatingEntityResolver(this.getClassLoader()), this.getHostEntityResolver()}));
    }

    protected void cancelRefresh(@NotNull BeansException ex) {
        if (ex == null) {
            throw new IllegalArgumentException("ex is null");
        }
        super.cancelRefresh(ex);
        try {
            this.getService(EventBus.class).publish((Event)new SpringContextException(this.getBundle(), (Exception)ex));
        }
        catch (Exception bx) {
            log.error("Failed to broadcast Spring refresh failure", (Throwable)bx);
        }
    }

    private void scanPackages(DefaultListableBeanFactory beanFactory, String[] configurationPackages) {
        if (log.isWarnEnabled()) {
            this.logWarnScanningOfImports(configurationPackages);
        }
        if (configurationPackages != null) {
            Descriptor serverDescriptor = this.getService(DescriptorService.class).getServerDescriptor();
            AlfrescoPlatformBeanDefinitionScanner scanner = new AlfrescoPlatformBeanDefinitionScanner((BeanDefinitionRegistry)beanFactory, serverDescriptor);
            scanner.setResourceLoader((ResourceLoader)this);
            scanner.scan(configurationPackages);
        }
    }

    private void logWarnScanningOfImports(String[] packagesToScan) {
        if (packagesToScan == null || packagesToScan.length == 0) {
            return;
        }
        BundleManifest bundleManifest = BundleManifestFactory.createBundleManifest((Dictionary)this.getBundle().getHeaders());
        List importedPackages = bundleManifest.getImportPackage().getImportedPackages().stream().map(ImportedPackage::getPackageName).flatMap(p -> DynamicExtensionsApplicationContextBase.recursifyPackage(p).stream()).collect(Collectors.toList());
        if (importedPackages.isEmpty()) {
            return;
        }
        List violatingPackages = Arrays.stream(packagesToScan).filter(importedPackages::contains).collect(Collectors.toList());
        if (!violatingPackages.isEmpty()) {
            log.warn("Bundle: '{}' --> Package(s) '{}' will be scanned for Spring beans but these are imported packages (see 'Import-Package' MANIFEST header), this can cause several issues like e.g. unintended, duplicate registration of some beans.", (Object)this.getBundle().getSymbolicName(), violatingPackages);
        }
    }

    static List<String> recursifyPackage(String s) {
        ArrayList<String> packagesRecursive = new ArrayList<String>();
        String[] packageParts = s.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (String packagePart : packageParts) {
            sb.append(packagePart);
            packagesRecursive.add(sb.toString());
            sb.append(".");
        }
        return packagesRecursive;
    }

    protected <TService> TService getService(Class<TService> clazz) {
        return BundleUtils.getService(this.getBundleContext(), clazz);
    }

    protected <TService> TService getService(Class<TService> clazz, String filter) {
        return BundleUtils.getService(this.getBundleContext(), clazz, filter);
    }

    protected NamespaceHandlerResolver getOsgiNamespaceHandlerResolver() {
        return this.getService(NamespaceHandlerResolver.class, BundleUtils.createNamespaceFilter(this.getBundleContext()));
    }

    protected NamespaceHandlerResolver getHostNamespaceHandlerResolver() {
        return this.getService(NamespaceHandlerResolver.class, HOST_APPLICATION_ALFRESCO_FILTER);
    }

    protected EntityResolver getOsgiEntityResolver() {
        return this.getService(EntityResolver.class, BundleUtils.createNamespaceFilter(this.getBundleContext()));
    }

    protected EntityResolver getHostEntityResolver() {
        return this.getService(EntityResolver.class, HOST_APPLICATION_ALFRESCO_FILTER);
    }

    protected String[] getBundleExportPackages() {
        String exportPackageHeader = (String)this.getBundle().getHeaders().get("Export-Package");
        if (StringUtils.hasText((String)exportPackageHeader)) {
            PackageAdmin packageAdmin = this.getService(PackageAdmin.class);
            ExportedPackage[] packages = packageAdmin.getExportedPackages(this.getBundle());
            String[] pkgNames = new String[packages.length];
            for (int index = 0; index != packages.length; ++index) {
                pkgNames[index] = packages[index].getName();
            }
            return pkgNames;
        }
        return new String[0];
    }

    protected boolean hasXmlConfiguration() {
        return this.hasXmlConfiguration;
    }

    protected final boolean hasSpringConfigurationHeader() {
        return this.getBundle().getHeaders().get(SPRING_CONFIGURATION_HEADER) != null;
    }

    protected final boolean isAlfrescoDynamicExtension() {
        return Boolean.valueOf((String)this.getBundle().getHeaders().get(ALFRESCO_DYNAMIC_EXTENSION_HEADER));
    }

    @Nullable
    protected final String[] getSpringConfigurationPackages() {
        String header = (String)this.getBundle().getHeaders().get(SPRING_CONFIGURATION_HEADER);
        if (StringUtils.hasText((String)header)) {
            return header.split(",");
        }
        return null;
    }

    protected void registerInfrastructureBeans(DefaultListableBeanFactory beanFactory) {
        if (beanFactory == null) {
            throw new IllegalArgumentException("beanFactory is null");
        }
        Descriptor serverDescriptor = this.getService(DescriptorService.class).getServerDescriptor();
        this.registerContentSupportBeans(beanFactory);
        this.registerModelDeploymentBeans(beanFactory);
        this.registerWorkflowDeployment(beanFactory);
        this.registerMessagesDeployment(beanFactory);
        this.registerAnnotationBasedBehaviourBeans(beanFactory);
        this.registerAnnotationBasedActionBeans(beanFactory);
        this.registerAnnotationBasedWebScriptBeans(beanFactory);
        this.registerAopProxyBeans(beanFactory);
        this.registerWorkflowBeans(beanFactory);
        this.registerOsgiServiceBeans(beanFactory);
        this.registerTaskSchedulingBeans(beanFactory, serverDescriptor);
        this.registerMetrics(beanFactory);
        this.registerWebResources(beanFactory);
    }

    private void registerContentSupportBeans(DefaultListableBeanFactory beanFactory) {
        this.bean((BeanDefinitionRegistry)beanFactory, BeanNames.RESOURCE_HELPER, ResourceHelper.class, beanAutowireByType);
        this.bean((BeanDefinitionRegistry)beanFactory, BeanNames.BOOTSTRAP_SERVICE, DefaultBootstrapService.class, beanAutowireByType);
    }

    private void registerModelDeploymentBeans(DefaultListableBeanFactory beanFactory) {
        this.bean(beanFactory, BeanNames.M2_MODEL_LIST_FACTORY, M2ModelResourceListProvider.class);
        this.bean((BeanDefinitionRegistry)beanFactory, BeanNames.MODEL_REGISTRAR, RepositoryModelRegistrar.class, new BeanDefinitionBuilderCustomizer(){

            @Override
            public void customize(BeanDefinitionBuilder builder) {
                builder.setAutowireMode(2);
                builder.setInitMethodName("registerModels");
                builder.setDestroyMethodName("unregisterModels");
            }
        });
    }

    private void registerWorkflowDeployment(DefaultListableBeanFactory beanFactory) {
        this.bean((BeanDefinitionRegistry)beanFactory, BeanNames.WORKFLOW_DEFINITION_REGISTRAR, WorkflowDefinitionRegistrar.class, beanAutowireByType);
    }

    private void registerMessagesDeployment(DefaultListableBeanFactory beanFactory) {
        this.bean((BeanDefinitionRegistry)beanFactory, BeanNames.MESSAGES_REGISTRAR, MessagesRegistrar.class, beanAutowireByType);
    }

    private void bean(@NotNull DefaultListableBeanFactory beanFactory, @NotNull BeanNames name, @NotNull Class beanClass) {
        this.bean((BeanDefinitionRegistry)beanFactory, name, beanClass, null);
    }

    private void bean(@NotNull BeanDefinitionRegistry beanFactory, @NotNull BeanNames name, @NotNull Class beanClass, @Nullable BeanDefinitionBuilderCustomizer body) {
        if (beanFactory == null) {
            throw new IllegalArgumentException("beanFactory is null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass is null");
        }
        if (!beanFactory.containsBeanDefinition(name.id())) {
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)beanClass);
            if (body != null) {
                body.customize(beanDefinitionBuilder);
            }
            beanFactory.registerBeanDefinition(name.id(), (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
        }
    }

    private void registerAnnotationBasedBehaviourBeans(DefaultListableBeanFactory beanFactory) {
        this.bean((BeanDefinitionRegistry)beanFactory, BeanNames.BEHAVIOUR_PROXY_FACTORY, DefaultBehaviourProxyFactory.class, beanAutowireByType);
        this.bean((BeanDefinitionRegistry)beanFactory, BeanNames.PROXY_POLICY_COMPONENT, ProxyPolicyComponentFactoryBean.class, new BeanDefinitionBuilderCustomizer(){

            @Override
            public void customize(BeanDefinitionBuilder builder) {
                builder.addPropertyReference("policyComponent", "policyComponent");
                builder.addPropertyReference("behaviourProxyFactory", BeanNames.BEHAVIOUR_PROXY_FACTORY.id());
            }
        });
        this.bean((BeanDefinitionRegistry)beanFactory, BeanNames.ANNOTATION_BASED_BEHAVIOUR_REGISTRAR, AnnotationBasedBehaviourRegistrar.class, new BeanDefinitionBuilderCustomizer(){

            @Override
            public void customize(BeanDefinitionBuilder builder) {
                builder.addPropertyReference("policyComponent", BeanNames.PROXY_POLICY_COMPONENT.id());
                builder.setAutowireMode(2);
                builder.setInitMethodName("bindBehaviours");
            }
        });
    }

    private void registerAnnotationBasedActionBeans(DefaultListableBeanFactory beanFactory) {
        this.bean((BeanDefinitionRegistry)beanFactory, BeanNames.ANNOTATION_BASED_ACTION_REGISTRAR, AnnotationBasedActionRegistrar.class, new BeanDefinitionBuilderCustomizer(){

            @Override
            public void customize(BeanDefinitionBuilder builder) {
                builder.setAutowireMode(2);
                builder.setInitMethodName("registerAnnotationBasedActions");
                builder.setDestroyMethodName("unregisterAnnotationBasedActions");
            }
        });
    }

    private void registerAnnotationBasedWebScriptBeans(DefaultListableBeanFactory beanFactory) {
        this.bean((BeanDefinitionRegistry)beanFactory, BeanNames.STRING_VALUE_CONVERTER, StringValueConverter.class, new BeanDefinitionBuilderCustomizer(){

            @Override
            public void customize(BeanDefinitionBuilder builder) {
                builder.addPropertyValue("namespacePrefixResolver", (Object)DynamicExtensionsApplicationContextBase.this.getService(NamespacePrefixResolver.class));
            }
        });
        this.bean(beanFactory, BeanNames.MESSAGE_CONVERTER_REGISTER, MessageConverterRegistry.class);
        this.bean((BeanDefinitionRegistry)beanFactory, BeanNames.HANDLER_METHOD_ARGUMENTS_RESOLVER, HandlerMethodArgumentsResolver.class, new BeanDefinitionBuilderCustomizer(){

            @Override
            public void customize(BeanDefinitionBuilder builder) {
                builder.addPropertyReference("stringValueConverter", BeanNames.STRING_VALUE_CONVERTER.id());
                builder.addPropertyReference("messageConverterRegistry", BeanNames.MESSAGE_CONVERTER_REGISTER.id());
                builder.addPropertyValue("bundleContext", (Object)DynamicExtensionsApplicationContextBase.this.getBundleContext());
                builder.setInitMethodName("initializeArgumentResolvers");
            }
        });
        this.bean((BeanDefinitionRegistry)beanFactory, BeanNames.ANNOTATION_BASED_WEB_SCRIPT_BUILDER, AnnotationWebScriptBuilder.class, new BeanDefinitionBuilderCustomizer(){

            @Override
            public void customize(BeanDefinitionBuilder builder) {
                builder.addPropertyReference("handlerMethodArgumentsResolver", BeanNames.HANDLER_METHOD_ARGUMENTS_RESOLVER.id());
                builder.addPropertyReference("messageConverterRegistry", BeanNames.MESSAGE_CONVERTER_REGISTER.id());
            }
        });
        this.bean((BeanDefinitionRegistry)beanFactory, BeanNames.ANNOTATION_BASED_WEB_SCRIPT_REGISTRAR, AnnotationWebScriptRegistrar.class, new BeanDefinitionBuilderCustomizer(){

            @Override
            public void customize(BeanDefinitionBuilder builder) {
                builder.addPropertyReference("annotationBasedWebScriptBuilder", BeanNames.ANNOTATION_BASED_WEB_SCRIPT_BUILDER.id());
                builder.addPropertyValue("webScriptUriRegistry", (Object)DynamicExtensionsApplicationContextBase.this.getService(WebScriptUriRegistry.class));
                builder.setInitMethodName("registerWebScripts");
                builder.setDestroyMethodName("unregisterWebScripts");
            }
        });
        this.bean((BeanDefinitionRegistry)beanFactory, BeanNames.SEARCH_PATH_REGISTRY_MANAGER, SearchPathRegistryManager.class, new BeanDefinitionBuilderCustomizer(){

            @Override
            public void customize(BeanDefinitionBuilder builder) {
                builder.addPropertyValue("searchPathRegistry", (Object)DynamicExtensionsApplicationContextBase.this.getService(SearchPathRegistry.class));
                builder.addPropertyValue("stores", (Object)new BundleStore(DynamicExtensionsApplicationContextBase.this.getBundle()));
                builder.addPropertyValue("templateProcessor", (Object)DynamicExtensionsApplicationContextBase.this.getService(TemplateProcessor.class));
                builder.setInitMethodName("registerStores");
                builder.setDestroyMethodName("unregisterStores");
            }
        });
    }

    private void registerAopProxyBeans(DefaultListableBeanFactory beanFactory) {
        this.bean(beanFactory, BeanNames.AUTO_PROXY_CREATOR, DynamicExtensionsAdvisorAutoProxyCreator.class);
    }

    private void registerWorkflowBeans(DefaultListableBeanFactory beanFactory) {
        try {
            WorkflowTaskRegistry.class.getClassLoader().loadClass("org.activiti.engine.delegate.JavaDelegate");
        }
        catch (Exception ignore) {
            return;
        }
        this.bean((BeanDefinitionRegistry)beanFactory, BeanNames.TYPE_BASED_WORKFLOW_REGISTRAR, WorkflowTaskRegistrar.class, new BeanDefinitionBuilderCustomizer(){

            @Override
            public void customize(BeanDefinitionBuilder builder) {
                builder.addConstructorArgReference("activitiBeanRegistry");
                builder.addConstructorArgReference("osgi.container.WorkflowTaskRegistry");
            }
        });
    }

    private void registerOsgiServiceBeans(DefaultListableBeanFactory beanFactory) {
        this.bean(beanFactory, BeanNames.OSGI_SERVICE_REGISTRAR, OsgiServiceRegistrar.class);
    }

    void registerTaskSchedulingBeans(DefaultListableBeanFactory beanFactory, Descriptor serverDescriptor) {
        VersionNumber version = serverDescriptor.getVersionNumber();
        if (version.compareTo(new VersionNumber("6.0")) >= 0) {
            this.bean((BeanDefinitionRegistry)beanFactory, BeanNames.QUARTZ_TASK_SCHEDULER, Quartz2TaskScheduler.class, beanAutowireByName);
        } else {
            this.bean((BeanDefinitionRegistry)beanFactory, BeanNames.QUARTZ_TASK_SCHEDULER, QuartzTaskScheduler.class, beanAutowireByName);
        }
        this.bean((BeanDefinitionRegistry)beanFactory, BeanNames.SCHEDULED_TASK_REGISTRAR, ScheduledTaskRegistrar.class, beanAutowireByType);
    }

    private void registerMetrics(DefaultListableBeanFactory beanFactory) {
        this.bean((BeanDefinitionRegistry)beanFactory, BeanNames.METRICS_TIMER, SpringTimer.class, beanAutowireByType);
    }

    private void registerWebResources(DefaultListableBeanFactory beanFactory) {
        this.bean((BeanDefinitionRegistry)beanFactory, BeanNames.RESOURCES_WEB, WebResourcesRegistrar.class, beanAutowireByType);
    }

    public static interface BeanDefinitionBuilderCustomizer {
        public void customize(BeanDefinitionBuilder var1);
    }
}

