/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.blueprint;

import com.github.dynamicextensionsalfresco.blueprint.BundleUtils;
import com.github.dynamicextensionsalfresco.blueprint.DynamicExtensionsApplicationContextBase;
import java.util.LinkedHashSet;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.util.VersionNumber;
import org.eclipse.gemini.blueprint.context.DelegatedExecutionOsgiBundleApplicationContext;
import org.eclipse.gemini.blueprint.context.support.ContextClassLoaderProvider;
import org.eclipse.gemini.blueprint.context.support.DefaultContextClassLoaderProvider;
import org.eclipse.gemini.blueprint.extender.OsgiApplicationContextCreator;
import org.eclipse.gemini.blueprint.extender.support.ApplicationContextConfiguration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public abstract class DynamicExtensionsApplicationContextCreatorBase
implements OsgiApplicationContextCreator {
    private static final String ALFRESCO_DYNAMIC_EXTENSION_HEADER = "Alfresco-Dynamic-Extension";
    private static final String HOST_APPLICATION_CONTEXT_BEAN_NAME = "HostApplicationContext";
    private static final String OSGI_SERVICE_BLUEPRINT_COMPNAME = "osgi.service.blueprint.compname";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public DelegatedExecutionOsgiBundleApplicationContext createApplicationContext(BundleContext bundleContext) throws Exception {
        Bundle bundle = bundleContext.getBundle();
        ApplicationContextConfiguration config = new ApplicationContextConfiguration(bundle);
        String[] configurationLocations = null;
        if (config.isSpringPoweredBundle()) {
            configurationLocations = config.getConfigurationLocations();
        }
        if (!(configurationLocations != null && configurationLocations.length != 0 || this.isAlfrescoDynamicExtension(bundle))) {
            return null;
        }
        if (this.isAlfrescoDynamicExtension(bundle)) {
            this.uninstallBundlesWithDuplicateSymbolicName(bundleContext);
        }
        DynamicExtensionsApplicationContextBase applicationContext = this.createNewInstance(configurationLocations, this.getHostApplicationContext(bundleContext));
        applicationContext.setBundleContext(bundleContext);
        DefaultContextClassLoaderProvider contextClassLoaderProvider = new DefaultContextClassLoaderProvider();
        contextClassLoaderProvider.setBeanClassLoader(ApplicationContext.class.getClassLoader());
        applicationContext.setContextClassLoaderProvider((ContextClassLoaderProvider)contextClassLoaderProvider);
        applicationContext.setPublishContextAsService(config.isPublishContextAsService());
        return applicationContext;
    }

    protected abstract DynamicExtensionsApplicationContextBase createNewInstance(String[] var1, ApplicationContext var2);

    protected boolean isAlfrescoDynamicExtension(Bundle bundle) {
        return Boolean.valueOf((String)bundle.getHeaders().get(ALFRESCO_DYNAMIC_EXTENSION_HEADER));
    }

    protected void uninstallBundlesWithDuplicateSymbolicName(BundleContext bundleContext) throws BundleException {
        Bundle currentBundle = bundleContext.getBundle();
        LinkedHashSet<Bundle> duplicateInstalledBundles = new LinkedHashSet<Bundle>();
        for (Bundle installedBundle : bundleContext.getBundles()) {
            if (currentBundle == installedBundle || currentBundle.getBundleId() == installedBundle.getBundleId() || !currentBundle.getSymbolicName().equals(installedBundle.getSymbolicName())) continue;
            duplicateInstalledBundles.add(installedBundle);
        }
        for (Bundle installedBundle : duplicateInstalledBundles) {
            try {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Overwriting existing installation of Dynamic Extension '{}'. It is recommended not to deploy multiple versions of the same Dynamic Extension.", (Object)installedBundle.getSymbolicName());
                }
                installedBundle.uninstall();
            }
            catch (BundleException e) {
                this.logger.error("Error uninstalling Bundle: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    protected ApplicationContext getHostApplicationContext(BundleContext bundleContext) {
        ServiceReference<?> serviceReference = this.getServiceReferenceWithBeanName(bundleContext, ApplicationContext.class.getName(), HOST_APPLICATION_CONTEXT_BEAN_NAME);
        if (serviceReference != null) {
            VersionNumber version = BundleUtils.getService(bundleContext, DescriptorService.class).getServerDescriptor().getVersionNumber();
            return this.getSpringSpecificHostApplicationContext(bundleContext, serviceReference);
        }
        return null;
    }

    protected abstract ApplicationContext getSpringSpecificHostApplicationContext(BundleContext var1, ServiceReference<?> var2);

    protected ServiceReference<?> getServiceReferenceWithBeanName(BundleContext bundleContext, String serviceName, String beanName) {
        try {
            String filter = String.format("(%s=%s)", OSGI_SERVICE_BLUEPRINT_COMPNAME, beanName);
            ServiceReference[] serviceReferences = bundleContext.getServiceReferences(serviceName, filter);
            if (serviceReferences != null && serviceReferences.length > 0) {
                return serviceReferences[0];
            }
            return null;
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

