/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.blueprint;

import com.github.dynamicextensionsalfresco.osgi.OsgiService;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.gemini.blueprint.context.BundleContextAware;
import org.eclipse.gemini.blueprint.service.exporter.support.OsgiServiceFactoryBean;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.ClassUtils;

public class OsgiServiceRegistrar
implements ApplicationContextAware,
BundleContextAware,
InitializingBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ApplicationContext applicationContext;
    private BundleContext bundleContext;

    public void afterPropertiesSet() throws Exception {
        Map exportables = this.applicationContext.getBeansWithAnnotation(OsgiService.class);
        for (Map.Entry entry : exportables.entrySet()) {
            OsgiService osgiService = (OsgiService)this.applicationContext.findAnnotationOnBean((String)entry.getKey(), OsgiService.class);
            this.registerOsgiService((String)entry.getKey(), osgiService);
        }
    }

    private void registerOsgiService(String beanName, OsgiService service) {
        Class type = this.applicationContext.getType(beanName);
        Class[] interfaces = this.getInterfaces(type, service);
        try {
            this.logger.debug("Registering bean {} as OSGi service using interfaces {}.", (Object)beanName, Arrays.asList(interfaces));
            OsgiServiceFactoryBean factoryBean = new OsgiServiceFactoryBean();
            factoryBean.setServiceProperties(this.getServiceProperties(service));
            factoryBean.setInterfaces(interfaces);
            factoryBean.setBeanFactory((BeanFactory)this.applicationContext);
            factoryBean.setTargetBeanName(beanName);
            factoryBean.setBundleContext(this.bundleContext);
            factoryBean.afterPropertiesSet();
        }
        catch (Exception e) {
            this.logger.warn("Error registering bean '{}' as OSGi service.", (Object)beanName, (Object)e);
        }
    }

    private Map getServiceProperties(OsgiService osgiService) {
        OsgiService.ExportHeader[] headers = osgiService.headers();
        Hashtable<String, String> properties = new Hashtable<String, String>(headers.length);
        for (OsgiService.ExportHeader header : headers) {
            properties.put(header.key(), header.value());
        }
        return properties;
    }

    protected Class<?>[] getInterfaces(Class<?> type, OsgiService service) {
        Class[] interfaces;
        if (type.isInterface()) {
            return new Class[]{type};
        }
        Class[] classArray = interfaces = service.interfaces().length > 0 ? service.interfaces() : ClassUtils.getAllInterfacesForClass(type);
        if (interfaces.length == 0) {
            return new Class[]{type};
        }
        return interfaces;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

