/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.blueprint.spring3;

import com.github.dynamicextensionsalfresco.BeanNames;
import com.github.dynamicextensionsalfresco.annotations.AlfrescoService;
import com.github.dynamicextensionsalfresco.annotations.ServiceType;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class Spring3OsgiAutowireBeanFactory
extends DefaultListableBeanFactory {
    private final BundleContext bundleContext;
    private final Set<String> internalBeanNames = new HashSet<String>();

    public Spring3OsgiAutowireBeanFactory(BeanFactory parentBeanFactory, BundleContext bundleContext) {
        super(parentBeanFactory);
        this.bundleContext = bundleContext;
        for (BeanNames beanName : BeanNames.values()) {
            this.internalBeanNames.add(beanName.id());
        }
    }

    protected Map<String, Object> findAutowireCandidates(String beanName, Class requiredType, DependencyDescriptor descriptor) {
        Map candidateBeansByName = Collections.emptyMap();
        if (BundleContext.class.isAssignableFrom(requiredType)) {
            candidateBeansByName = new HashMap(1);
            candidateBeansByName.put(requiredType.getName(), this.bundleContext);
        } else {
            ServiceReference serviceReference = this.bundleContext.getServiceReference(requiredType);
            if (serviceReference != null) {
                candidateBeansByName = new HashMap(1);
                candidateBeansByName.put(requiredType.getName(), this.bundleContext.getService(serviceReference));
            }
        }
        if (candidateBeansByName.isEmpty()) {
            candidateBeansByName = super.findAutowireCandidates(beanName, requiredType, descriptor);
        }
        return candidateBeansByName;
    }

    protected String determinePrimaryCandidate(Map<String, Object> candidateBeans, DependencyDescriptor descriptor) {
        String beanName = ClassUtils.getShortName((Class)descriptor.getDependencyType());
        for (String id : candidateBeans.keySet()) {
            if (!this.internalBeanNames.contains(id)) continue;
            return id;
        }
        AlfrescoService alfrescoService = this.getAnnotation(descriptor, AlfrescoService.class);
        ServiceType serviceType = alfrescoService != null ? alfrescoService.value() : ServiceType.DEFAULT;
        switch (serviceType) {
            default: {
                if (!candidateBeans.containsKey(beanName)) break;
                return beanName;
            }
            case LOW_LEVEL: 
        }
        beanName = StringUtils.uncapitalize((String)beanName);
        if (candidateBeans.containsKey(beanName)) {
            return beanName;
        }
        return super.determinePrimaryCandidate(candidateBeans, descriptor);
    }

    private <T extends Annotation> T getAnnotation(DependencyDescriptor descriptor, Class<T> annotationType) {
        for (Annotation annotation : descriptor.getAnnotations()) {
            if (!annotationType.isAssignableFrom(annotation.annotationType())) continue;
            return (T)annotation;
        }
        return null;
    }
}

