/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.schedule.quartz;

import com.github.dynamicextensionsalfresco.schedule.TaskConfiguration;
import com.github.dynamicextensionsalfresco.schedule.TaskRegistration;
import com.github.dynamicextensionsalfresco.schedule.TaskSchedulerException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;

public class QuartzTaskRegistration
implements TaskRegistration {
    private final Scheduler scheduler;
    private final String name;
    private final String group;

    public QuartzTaskRegistration(Scheduler scheduler, String name, String group) {
        this.scheduler = scheduler;
        this.name = name;
        this.group = group;
    }

    public QuartzTaskRegistration(Scheduler scheduler, TaskConfiguration config) {
        this(scheduler, config.getName(), config.getGroup());
    }

    public void unregister() throws TaskSchedulerException {
        try {
            this.scheduler.unscheduleJob(this.name, this.group);
        }
        catch (SchedulerException e) {
            throw new TaskSchedulerException((Exception)((Object)e));
        }
    }

    public void trigger() throws TaskSchedulerException {
        try {
            this.scheduler.triggerJob(this.name, this.group);
        }
        catch (SchedulerException e) {
            throw new TaskSchedulerException((Exception)((Object)e));
        }
    }
}

