/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.schedule.quartz;

import com.github.dynamicextensionsalfresco.schedule.Task;
import com.github.dynamicextensionsalfresco.schedule.TaskConfiguration;
import com.github.dynamicextensionsalfresco.schedule.TaskRegistration;
import com.github.dynamicextensionsalfresco.schedule.TaskScheduler;
import com.github.dynamicextensionsalfresco.schedule.TaskSchedulerException;
import com.github.dynamicextensionsalfresco.schedule.quartz.ClusterLockedQuartzJob;
import com.github.dynamicextensionsalfresco.schedule.quartz.GenericQuartzJob;
import com.github.dynamicextensionsalfresco.schedule.quartz.QuartzTaskRegistration;
import java.text.ParseException;
import org.alfresco.repo.lock.JobLockService;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class QuartzTaskScheduler
implements TaskScheduler {
    private static final Logger log = LoggerFactory.getLogger(QuartzTaskScheduler.class);
    static final Object BEAN_ID = "bean";
    static final String JOB_LOCK_SERVICE = "jobLockService";
    @Autowired
    @Qualifier(value="schedulerFactory")
    private Scheduler scheduler;
    @Autowired
    private JobLockService jobLockService;

    public TaskRegistration scheduleTask(TaskConfiguration config, Object bean) throws TaskSchedulerException {
        if (config == null) {
            throw new IllegalArgumentException("config is null");
        }
        if (bean == null) {
            throw new IllegalArgumentException("bean is null");
        }
        if (this.scheduler == null) {
            throw new IllegalStateException("schedule is null");
        }
        try {
            if (!Task.class.isAssignableFrom(bean.getClass())) {
                if (Job.class.isAssignableFrom(bean.getClass())) {
                    log.warn("[DEPRECATION] '{}' Implementing {} directly is deprecated, please implement {}", new Object[]{bean.getClass().getCanonicalName(), Job.class.getName(), Task.class.getName()});
                } else {
                    throw new IllegalArgumentException(String.format("argument 'bean' does not implement interface " + Task.class.getName(), new Object[0]));
                }
            }
            CronTrigger trigger = new CronTrigger(config.getName(), config.getGroup(), config.getCron());
            JobDetail jobDetail = new JobDetail(config.getName(), config.getGroup(), this.getJobClass(config));
            JobDataMap map = new JobDataMap();
            map.put(BEAN_ID, bean);
            map.put((Object)JOB_LOCK_SERVICE, (Object)this.jobLockService);
            map.put("name", trigger.getKey().toString());
            jobDetail.setJobDataMap(map);
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            return new QuartzTaskRegistration(this.scheduler, config);
        }
        catch (ParseException | SchedulerException e) {
            throw new TaskSchedulerException((Exception)e);
        }
    }

    private Class getJobClass(TaskConfiguration config) {
        return config.isCluster() ? ClusterLockedQuartzJob.class : GenericQuartzJob.class;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }
}

