/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.messages;

import com.github.dynamicextensionsalfresco.resources.BootstrapService;
import com.github.dynamicextensionsalfresco.resources.ContentCompareStrategy;
import com.github.dynamicextensionsalfresco.resources.ResourceHelper;
import com.github.dynamicextensionsalfresco.resources.UpdateStrategy;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Resource;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.RepositoryLocation;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.transaction.TransactionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class MessagesRegistrar
implements InitializingBean {
    private static final String BUNDLE_MESSAGES = "osgibundle:/META-INF/alfresco/messages/*.properties";
    private static final String MESSAGES_TARGET = "/app:company_home/app:dictionary/app:messages";
    private static final Logger logger = LoggerFactory.getLogger(MessagesRegistrar.class);
    @Autowired
    protected BootstrapService bootstrapService;
    @Autowired
    @Resource(name="messageService")
    protected MessageService messageService;
    @Autowired
    private ResourceHelper resourceHelper;
    @Autowired
    private TransactionService transactionService;

    public void afterPropertiesSet() throws Exception {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                try {
                    MessagesRegistrar.this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                        public Object execute() throws Throwable {
                            logger.debug("Deploying messages...");
                            RepositoryLocation repositoryLocation = new RepositoryLocation(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, MessagesRegistrar.MESSAGES_TARGET, "xpath");
                            Map resources = MessagesRegistrar.this.bootstrapService.deployResources(MessagesRegistrar.BUNDLE_MESSAGES, repositoryLocation, (UpdateStrategy)new ContentCompareStrategy(MessagesRegistrar.this.resourceHelper), null, "text/plain", ContentModel.TYPE_CONTENT);
                            HashSet<String> registered = new HashSet<String>();
                            for (org.springframework.core.io.Resource resource : resources.keySet()) {
                                String baseName = resource.getFilename().replaceAll("^([a-z-A-Z]+)(_|.).+$", "$1");
                                String messageBundlePath = StoreRef.STORE_REF_WORKSPACE_SPACESSTORE + repositoryLocation.getPath() + "/cm:" + baseName;
                                if (registered.contains(baseName)) continue;
                                logger.debug("Registering messagebundle {}", (Object)messageBundlePath);
                                MessagesRegistrar.this.messageService.registerResourceBundle(messageBundlePath);
                                registered.add(baseName);
                            }
                            logger.debug("Deploying messages done.");
                            String message = MessagesRegistrar.this.messageService.getMessage("cm_contentmodel.property.cm_name.title", Locale.US);
                            logger.debug("Fetching failing message {}", (Object)message);
                            return null;
                        }
                    }, false, false);
                }
                catch (Exception e) {
                    logger.error("tx error", (Throwable)e);
                }
                return null;
            }
        });
    }
}

