/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.models;

import com.github.dynamicextensionsalfresco.models.M2ModelListProvider;
import com.github.dynamicextensionsalfresco.models.M2ModelResource;
import com.github.dynamicextensionsalfresco.models.ModelRegistrar;
import com.github.dynamicextensionsalfresco.osgi.DependencyMetadataProvider;
import com.github.dynamicextensionsalfresco.osgi.DependencySorter;
import java.util.ArrayList;
import java.util.Collection;
import org.alfresco.repo.dictionary.M2Namespace;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;

public abstract class AbstractModelRegistrar
implements ModelRegistrar,
ResourceLoaderAware,
DependencyMetadataProvider<M2ModelResource> {
    private final Logger logger = LoggerFactory.getLogger(AbstractModelRegistrar.class);
    protected ResourcePatternResolver resourcePatternResolver;
    public M2ModelListProvider modelsToRegister;

    public AbstractModelRegistrar() {
    }

    public AbstractModelRegistrar(M2ModelListProvider modelsToRegister) {
        this.modelsToRegister = modelsToRegister;
    }

    @Autowired
    public void setModelsToRegister(M2ModelListProvider modelsToRegister) {
        this.modelsToRegister = modelsToRegister;
    }

    private void setResourcePatternResolver(ResourcePatternResolver resourcePatternResolver) {
        this.resourcePatternResolver = resourcePatternResolver;
    }

    @Override
    public void registerModels() {
        Collection<M2ModelResource> sortedModels = DependencySorter.sort(this.modelsToRegister.getModels(), this);
        for (M2ModelResource modelResource : sortedModels) {
            try {
                this.registerModel(modelResource);
            }
            catch (DictionaryException e) {
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn("Could not register model '${modelResource.name}'", (Throwable)e);
            }
        }
    }

    @Override
    public Collection<Object> imports(M2ModelResource item) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (M2Namespace it : item.getM2Model().getImports()) {
            ret.add(it.getUri());
        }
        return ret;
    }

    protected abstract void registerModel(M2ModelResource var1);

    @Override
    public Collection<Object> exports(M2ModelResource item) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (M2Namespace it : item.getM2Model().getNamespaces()) {
            ret.add(it.getUri());
        }
        return ret;
    }

    @Override
    public boolean allowCircularReferences() {
        return false;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourcePatternResolver = (ResourcePatternResolver)resourceLoader;
    }
}

