/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.models;

import com.github.dynamicextensionsalfresco.models.AbstractModelRegistrar;
import com.github.dynamicextensionsalfresco.models.M2ModelListProvider;
import com.github.dynamicextensionsalfresco.models.M2ModelResource;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.service.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DAOModelRegistrar
extends AbstractModelRegistrar {
    private final Logger logger = LoggerFactory.getLogger(DAOModelRegistrar.class);
    private final DictionaryDAO dictionaryDao;
    private final List<QName> registeredModelNames = new LinkedList<QName>();

    public DAOModelRegistrar(DictionaryDAO dictionaryDao, M2ModelListProvider modelsToRegister) {
        super(modelsToRegister);
        this.dictionaryDao = dictionaryDao;
    }

    @Override
    protected void registerModel(M2ModelResource modelResource) {
        QName qname = this.dictionaryDao.putModel(modelResource.getM2Model());
        this.registeredModelNames.add(qname);
    }

    @Override
    public void unregisterModels() {
        Iterator<QName> it = this.registeredModelNames.iterator();
        while (it.hasNext()) {
            QName modelName = it.next();
            try {
                this.logger.debug("Unregistering model '{}' via DictionaryDAO", (Object)modelName);
                this.dictionaryDao.removeModel(modelName);
            }
            finally {
                it.remove();
            }
        }
    }
}

