/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.models;

import com.github.dynamicextensionsalfresco.models.M2ModelListProvider;
import com.github.dynamicextensionsalfresco.models.M2ModelResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.dictionary.M2Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;

public class M2ModelResourceListProvider
implements M2ModelListProvider,
ResourceLoaderAware {
    private final Logger logger = LoggerFactory.getLogger(M2ModelResourceListProvider.class);
    private final String modelLocationPattern = "osgibundle:/META-INF/alfresco/models/*.xml";
    protected ResourcePatternResolver resourcePatternResolver;
    private List<M2ModelResource> _models;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        Assert.isInstanceOf(ResourcePatternResolver.class, (Object)resourceLoader);
        this.resourcePatternResolver = (ResourcePatternResolver)resourceLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<M2ModelResource> getModels() {
        if (this._models == null) {
            M2ModelResourceListProvider m2ModelResourceListProvider = this;
            synchronized (m2ModelResourceListProvider) {
                if (this._models == null) {
                    this._models = this.createModels();
                }
            }
        }
        return this._models;
    }

    protected List<M2ModelResource> createModels() {
        ArrayList<M2ModelResource> models = new ArrayList<M2ModelResource>();
        try {
            for (Resource resource : this.resourcePatternResolver.getResources("osgibundle:/META-INF/alfresco/models/*.xml")) {
                try {
                    M2Model model = this.createM2Model(resource);
                    models.add(new M2ModelResource(resource, model));
                }
                catch (Exception e) {
                    this.logger.warn("Could not create model from {}: {}", (Object)resource, (Object)e.getMessage());
                }
            }
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Failed to create model", (Throwable)e);
        }
        return models;
    }

    protected M2Model createM2Model(Resource resource) throws IOException {
        return M2Model.createModel((InputStream)resource.getInputStream());
    }
}

