/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.models;

import com.github.dynamicextensionsalfresco.models.AbstractModelRegistrar;
import com.github.dynamicextensionsalfresco.models.M2ModelResource;
import com.github.dynamicextensionsalfresco.resources.ResourceHelper;
import org.alfresco.repo.dictionary.RepositoryLocation;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.transaction.TransactionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RepositoryModelRegistrar
extends AbstractModelRegistrar {
    private Logger logger = LoggerFactory.getLogger(RepositoryModelRegistrar.class);
    @Autowired
    public RepositoryLocation customModelsRepositoryLocation;
    @Autowired
    public NodeService nodeService;
    @Autowired
    public RepoAdminService repoAdminService;
    @Autowired
    public TransactionService transactionService;
    @Autowired
    public ResourceHelper resourceHelper;

    @Override
    public void unregisterModels() {
    }

    @Override
    public void registerModel(M2ModelResource modelResource) {
        AuthenticationUtil.runAsSystem(() -> {
            try {
                this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
                    try {
                        if (this.resourceHelper.nodeDiffersFromResource(modelResource.getResource(), this.customModelsRepositoryLocation)) {
                            this.repoAdminService.deployModel(modelResource.getResource().getInputStream(), modelResource.getResource().getFilename());
                            this.logger.debug("Registered model {}", (Object)modelResource.getName());
                        }
                    }
                    catch (Exception e) {
                        this.logger.error("Failed to deploy M2Model {} as a cm:dictionaryModel", (Object)modelResource.getName(), (Object)e);
                    }
                    return null;
                }, false, true);
            }
            catch (Exception e) {
                this.logger.error("tx error", (Throwable)e);
            }
            return null;
        });
    }
}

