/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.osgi;

import com.github.dynamicextensionsalfresco.osgi.DependencyMetadataProvider;
import com.github.dynamicextensionsalfresco.osgi.DependencySorter;
import com.springsource.util.osgi.manifest.BundleManifest;
import com.springsource.util.osgi.manifest.BundleManifestFactory;
import com.springsource.util.osgi.manifest.ExportedPackage;
import com.springsource.util.osgi.manifest.ImportedPackage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.Bundle;

public final class BundleDependencies {
    private static final BundleMetadataProvider bundleMetadataProvider = new BundleMetadataProvider();

    private BundleDependencies() {
    }

    public static List<Bundle> sortByDependencies(List<Bundle> bundles) {
        if (bundles.size() == 1) {
            return bundles;
        }
        List<BundleDescriptor> descriptors = Mapper.map(bundles, new MappingFunc<Bundle, BundleDescriptor>(){

            @Override
            public BundleDescriptor map(Bundle item) {
                return new BundleDescriptor(item);
            }
        });
        Collection<BundleDescriptor> sorted = DependencySorter.sort(descriptors, bundleMetadataProvider);
        return Mapper.map(sorted, new MappingFunc<BundleDescriptor, Bundle>(){

            @Override
            public Bundle map(BundleDescriptor item) {
                return item.getBundle();
            }
        });
    }

    static class Mapper {
        Mapper() {
        }

        public static <T, R> List<R> map(Collection<T> list, MappingFunc<T, R> func) {
            if (list == null) {
                throw new IllegalArgumentException("list is null");
            }
            if (func == null) {
                throw new IllegalArgumentException("func is null");
            }
            ArrayList<R> result = new ArrayList<R>(list.size());
            for (T item : list) {
                result.add(func.map(item));
            }
            return result;
        }
    }

    static interface MappingFunc<T, R> {
        public R map(T var1);
    }

    public static class BundleDescriptor {
        private final Bundle bundle;
        private final BundleManifest manifest;

        BundleDescriptor(@NotNull Bundle bundle) {
            if (bundle == null) {
                throw new IllegalArgumentException("bundle is null");
            }
            this.bundle = bundle;
            this.manifest = BundleManifestFactory.createBundleManifest((Dictionary)bundle.getHeaders());
        }

        public String toString() {
            return String.format("%3d: %s", this.bundle.getBundleId(), this.bundle.getSymbolicName());
        }

        BundleManifest getManifest() {
            return this.manifest;
        }

        Bundle getBundle() {
            return this.bundle;
        }
    }

    public static class BundleMetadataProvider
    implements DependencyMetadataProvider<BundleDescriptor> {
        @Override
        public boolean allowCircularReferences() {
            return true;
        }

        @Override
        public Collection<Object> imports(BundleDescriptor item) {
            List imports = item.getManifest().getImportPackage().getImportedPackages();
            return Mapper.map(imports, new MappingFunc<ImportedPackage, Object>(){

                @Override
                public Object map(ImportedPackage item) {
                    return item.getPackageName();
                }
            });
        }

        @Override
        public Collection<Object> exports(BundleDescriptor item) {
            List exports = item.getManifest().getExportPackage().getExportedPackages();
            return Mapper.map(exports, new MappingFunc<ExportedPackage, Object>(){

                @Override
                public Object map(ExportedPackage item) {
                    return item.getPackageName();
                }
            });
        }
    }
}

