/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.osgi;

import com.github.dynamicextensionsalfresco.osgi.PackageCacheMode;
import java.io.File;

public class Configuration {
    private static final String TMP_DIR = "java.io.tmpdir";
    private boolean frameworkRestartEnabled = true;
    private boolean hotDeployEnabled = true;
    private boolean repositoryBundlesEnabled = true;
    private File storageDirectory = null;
    private PackageCacheMode systemPackageCacheMode = null;
    private File systemPackageCache = null;
    private String bootDelegation = null;

    public boolean getFrameworkRestartEnabled() {
        return this.frameworkRestartEnabled;
    }

    public void setFrameworkRestartEnabled(boolean frameworkRestartEnabled) {
        this.frameworkRestartEnabled = frameworkRestartEnabled;
    }

    public boolean getHotDeployEnabled() {
        return this.hotDeployEnabled;
    }

    public void setHotDeployEnabled(boolean hotDeployEnabled) {
        this.hotDeployEnabled = hotDeployEnabled;
    }

    public boolean getRepositoryBundlesEnabled() {
        return this.repositoryBundlesEnabled;
    }

    public void setRepositoryBundlesEnabled(boolean repositoryBundlesEnabled) {
        this.repositoryBundlesEnabled = repositoryBundlesEnabled;
    }

    public File getStorageDirectory() {
        if (this.storageDirectory == null) {
            this.storageDirectory = Configuration.createTempFile("bundles");
        }
        return this.storageDirectory;
    }

    public void setStorageDirectory(File storageDirectory) {
        this.storageDirectory = storageDirectory;
    }

    public PackageCacheMode getSystemPackageCacheMode() {
        return this.systemPackageCacheMode;
    }

    public void setSystemPackageCacheMode(PackageCacheMode packageCacheMode) {
        this.systemPackageCacheMode = packageCacheMode;
    }

    public File getSystemPackageCache() {
        if (this.systemPackageCache == null) {
            this.systemPackageCache = Configuration.createTempFile("system-packages.txt");
        }
        return this.systemPackageCache;
    }

    public String getBootDelegation() {
        return this.bootDelegation;
    }

    public void setBootDelegation(String bootDelegation) {
        this.bootDelegation = bootDelegation;
    }

    private static File createTempFile(String child) {
        return new File(System.getProperty(TMP_DIR), child);
    }
}

